#SHADER_DEFINE BrighteyeblendVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  BrighteyeblendFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_ORIGIN,            NONE,      TEXTURE2D,     "in_OriginTexture"},
        { TEXTURE_EYEMASK,           NONE,      TEXTURE2D,    "in_EyeMaskTexture"},
        { UNIFORM_STRENGTH,         MEDIUM,         FLOAT,             "strength"},
        { UNIFORM_BRIGHTSCALE,       LOW,           FLOAT,        "brightscale"  },
        { ATTRIBUTE_COORDNATE0,      HIGH,           VEC2,    "in_TexCoordinate" },
    }

#SHADER_CODE
    vec4 sourceColor = texture2D(in_OriginTexture, in_TexCoordinate);
    vec4 maskColor = texture2D(in_EyeMaskTexture, in_TexCoordinate);
    vec4 blurColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    // 统计颜色
    vec3 sumColor = vec3(0.0, 0.0, 0.0);
    // 将RGB颜色差值放大。突出眼睛明亮部分
    sumColor = clamp((sourceColor.rgb - blurColor.rgb) * brightscale, 0.0, 1.0);
    sumColor = max(sourceColor.rgb, sumColor);

    gl_FragColor = mix(sourceColor, vec4(sumColor, 1.0), maskColor.r*strength);;
#END_CODE
#END_DEFINE
