

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Outline2"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_uBwm;
sampler2D TEXTURE_uTua;
float2 UNIFORM_uOs;
float UNIFORM_uHiu;
float UNIFORM_uJhi;
float UNIFORM_uKj;
float UNIFORM_uVer;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float2 sos;
    //if (abs(uVer - 2.0) < 0.0001) {
        sos = normalize(decode(tex2D(TEXTURE_uBwm, i.uv)));
    //}
    //else sos = texture2D(uBwm, vUV).xy;

    float2 zz0 = sos;
    float2 zz1 = -sos;
    float2 uv0 = i.uv;
    float2 uv1 = i.uv;

    float k = gauss(0.0, UNIFORM_uHiu);
    float sum = k;
    float2 result = tex2D(TEXTURE_uTua, i.uv).rg * k;

    for (int j = 1; j < 7; ++j) {
        uv0 += zz0 * UNIFORM_uOs * sqrt(float(j));
        float2 c = tex2D(TEXTURE_uTua, uv0).rg;
        float2 good;
        //if ( abs(uVer - 2.0) < 0.0001) 
		//{
            good = normalize(decode(tex2D(TEXTURE_uBwm, uv0)));
        //}
        //else good = normalize(texture2D(uBwm, uv0).xy);

        zz0 = sign(dot(good, zz0)) * good;
        
        k = gauss(float(j), UNIFORM_uHiu);
        sum += k;
        result += c * k;
    }

    for (int j = 1; j < 7; ++j) {
        uv1 += zz1 * UNIFORM_uOs * sqrt(float(j));
        float2 c = tex2D(TEXTURE_uTua, uv1).rg;
        float2 good;
       // if (abs(uVer - 2.0) < 0.0001) {
            good = normalize(decode(tex2D(TEXTURE_uBwm, uv1)));
        //}
        //else good = normalize(texture2D(uBwm, uv1).xy);

        zz1 = sign(dot(good, zz1)) * good;
        
        k = gauss(float(j), UNIFORM_uHiu);
        sum += k;
        result += c * k;
    }
    result /= sum;

    float dad = UNIFORM_uJhi / 5.0;

 //   result.r = (result.r > 0.) ? 1.0 : 1.0 + rvr(10.0 * 1.0 * (result.r - 0.));
    result.g = (result.g > dad) ? 1.0 : 1.0 + rvr(10.0 * UNIFORM_uKj * 3. * (result.g - dad));

    return float4(result.gggg);
    //gl_FragColor = texture2D(uTua, vUV);
}
ENDCG
#END
