
function DefineParams()
	Properties = 
	{
		
HISTORICAL_FRAME1 = { "Frame Tex1", TEXTURE2D, "white" },
HISTORICAL_FRAME2 = { "Frame Tex2", TEXTURE2D, "white" },
HISTORICAL_FRAME3 = { "Frame Tex3", TEXTURE2D, "white" },
HISTORICAL_FRAME4 = { "Frame Tex4", TEXTURE2D, "white" },
INTERLACE_OFFSET_TEX = { "Interlace Tex", TEXTURE2D, "white" },
FRAME_SIZE = { "Frame size", FLOAT, "0.0"},
CUR_FRAME_ID = { "Cur FrameID", FLOAT, "0.0"},
ROW_FRAME_NUM_PER_TEX = { "Row Fame Num", FLOAT, "1.0"},
COL_FRAME_NUM_PER_TEX = { "Col Frame Num", FLOAT, "1.0"},
INTERLACE_MODE = { "Interlace Mode", FLOAT, "0.0"},
TIME_FACTOR = { "Time Factor", FLOAT, "0.0"},
WAVE_FACTOR = { "Wave Factor", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Interlace"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "HISTORICAL_FRAME1",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME3",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME4",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INTERLACE_OFFSET_TEX",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_SIZE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUR_FRAME_ID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROW_FRAME_NUM_PER_TEX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COL_FRAME_NUM_PER_TEX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INTERLACE_MODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TIME_FACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WAVE_FACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D HISTORICAL_FRAME1;
uniform sampler2D HISTORICAL_FRAME2;
uniform sampler2D HISTORICAL_FRAME3;
uniform sampler2D HISTORICAL_FRAME4;
uniform sampler2D INTERLACE_OFFSET_TEX;
uniform highp float FRAME_SIZE;
uniform highp float CUR_FRAME_ID;
uniform highp float ROW_FRAME_NUM_PER_TEX;
uniform highp float COL_FRAME_NUM_PER_TEX;
uniform highp float INTERLACE_MODE;
uniform highp float TIME_FACTOR;
uniform highp float WAVE_FACTOR;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  highp int frame_offset_2;
  highp float ratio_3;
  highp int tmpvar_4;
  tmpvar_4 = int(ROW_FRAME_NUM_PER_TEX);
  highp int tmpvar_5;
  tmpvar_5 = int(COL_FRAME_NUM_PER_TEX);
  highp int tmpvar_6;
  tmpvar_6 = (tmpvar_4 * tmpvar_5);
  ratio_3 = 0.0;
  highp float tmpvar_7;
  tmpvar_7 = sin((6.283185 * (
    (xlv_TEXCOORD0.x + xlv_TEXCOORD0.y)
   + TIME_FACTOR)));
  highp float tmpvar_8;
  tmpvar_8 = sin((6.283185 * TIME_FACTOR));
  if ((INTERLACE_MODE > 0.0)) {
    ratio_3 = (xlv_TEXCOORD0.y + ((
      (((0.1 * WAVE_FACTOR) * ((0.5 * tmpvar_8) + (tmpvar_8 * tmpvar_8))) * ((xlv_TEXCOORD0.x * xlv_TEXCOORD0.x) + (0.5 * xlv_TEXCOORD0.x)))
     * tmpvar_7) * tmpvar_7));
  } else {
    ratio_3 = (xlv_TEXCOORD0.x + ((
      (((0.1 * WAVE_FACTOR) * ((0.5 * tmpvar_8) + (tmpvar_8 * tmpvar_8))) * ((xlv_TEXCOORD0.y * xlv_TEXCOORD0.y) + (0.5 * xlv_TEXCOORD0.y)))
     * tmpvar_7) * tmpvar_7));
  };
  highp vec2 tmpvar_9;
  tmpvar_9.y = 0.0;
  tmpvar_9.x = ratio_3;
  lowp int tmpvar_10;
  tmpvar_10 = int((255.0 * texture (INTERLACE_OFFSET_TEX, tmpvar_9).x));
  frame_offset_2 = tmpvar_10;
  highp float denom_11;
  denom_11 = float(int(FRAME_SIZE));
  highp float res_12;
  highp float tmpvar_13;
  tmpvar_13 = (fract((
    float((int(CUR_FRAME_ID) - frame_offset_2))
   / denom_11)) * denom_11);
  res_12 = tmpvar_13;
  if ((tmpvar_13 < 0.0)) {
    res_12 = (tmpvar_13 + denom_11);
  };
  highp int tmpvar_14;
  tmpvar_14 = int(res_12);
  highp int tmpvar_15;
  tmpvar_15 = (tmpvar_14 / tmpvar_6);
  highp int tmpvar_16;
  tmpvar_16 = (tmpvar_14 - (tmpvar_6 * tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = (1.0/(float(tmpvar_4)));
  highp float tmpvar_18;
  tmpvar_18 = (1.0/(float(tmpvar_5)));
  highp int tmpvar_19;
  tmpvar_19 = (tmpvar_16 / tmpvar_4);
  highp vec2 tmpvar_20;
  tmpvar_20.x = (tmpvar_17 * float((tmpvar_16 - 
    (tmpvar_4 * tmpvar_19)
  )));
  tmpvar_20.y = (tmpvar_18 * float((
    (tmpvar_5 - 1)
   - tmpvar_19)));
  highp vec2 tmpvar_21;
  tmpvar_21.x = tmpvar_17;
  tmpvar_21.y = tmpvar_18;
  highp vec2 tmpvar_22;
  tmpvar_22 = (tmpvar_20 + (tmpvar_21 * xlv_TEXCOORD0));
  rgb_1 = vec3(0.0, 0.0, 0.0);
  if ((tmpvar_15 == 0)) {
    lowp vec4 tmpvar_23;
    tmpvar_23 = texture (HISTORICAL_FRAME1, tmpvar_22);
    rgb_1 = tmpvar_23.xyz;
  } else {
    if ((tmpvar_15 == 1)) {
      lowp vec4 tmpvar_24;
      tmpvar_24 = texture (HISTORICAL_FRAME2, tmpvar_22);
      rgb_1 = tmpvar_24.xyz;
    } else {
      if ((tmpvar_15 == 2)) {
        lowp vec4 tmpvar_25;
        tmpvar_25 = texture (HISTORICAL_FRAME3, tmpvar_22);
        rgb_1 = tmpvar_25.xyz;
      } else {
        if ((tmpvar_15 == 3)) {
          lowp vec4 tmpvar_26;
          tmpvar_26 = texture (HISTORICAL_FRAME4, tmpvar_22);
          rgb_1 = tmpvar_26.xyz;
        };
      };
    };
  };
  highp vec4 tmpvar_27;
  tmpvar_27.w = 1.0;
  tmpvar_27.xyz = rgb_1;
  _glesFragData[0] = tmpvar_27;
}

]===],
	},
}

end
