#DEFPARAMS
#END

#DEFTAG
ShaderName = "Portrait"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "functions/liveportrait.inc"
#include "common.inc"

struct appdata   
{
    float3 vertex           : POSITION;
    float2 uv               : TEXCOORD0;
    float  enableModelView  : COLOR;
};

struct v2f
{
    float2 uv               : TEXCOORD0;
    float4 vertex           : SV_POSITION;
};

float4x4 PROJECTION;
float4x4 MODELVIEW;

sampler2D TEXTURE_DIFFUSE;

float     ENABLE_WRINKLE;
sampler2D TEXTURE_WRINKLE;
sampler2D TEXTURE_FOREHEAD_MASK;
sampler2D TEXTURE_LDECREE_MASK;
sampler2D TEXTURE_RDECREE_MASK;
float     FOREHEAD_FACTOR;
float     DECREE_FACTOR;

float3    ORIGIN_FOREHEAD_CENTER[2];
float3    CUR_FOREHEAD_CENTER[2];
float3    ORIGIN_LMOUTH_CORNER[2];
float3    CUR_LMOUTH_CORNER[2];
float3    ORIGIN_RMOUTH_CORNER[2];
float3    CUR_RMOUTH_CORNER[2];

v2f vert(appdata v)
{
    float4 pos;
    if (v.enableModelView > 0.5)
        pos = mul(mul(PROJECTION, MODELVIEW), float4(v.vertex, 1.0));
    else
        pos = mul(PROJECTION, float4(v.vertex, 1.0));
      
    v2f o;  
    o.uv = v.uv;
    o.vertex = UniformNDC(pos);
    return o;
}

float4 frag(v2f i) : SV_Target
{
    if (ENABLE_WRINKLE > 0.5)
    {
        float4 img_color = tex2D(TEXTURE_DIFFUSE, i.uv);
        float4 img_color_yuv = RGB2YUV(img_color);
        
        float isForeHeadRegion = tex2D(TEXTURE_FOREHEAD_MASK, i.uv).r;
        float isLDecreeRegion = tex2D(TEXTURE_LDECREE_MASK, i.uv).r;
        float isRDecreeRegion = tex2D(TEXTURE_RDECREE_MASK, i.uv).r;
        
        float cur_wrinkle_extent = 0.0;
        if (isForeHeadRegion > 0.5)
        {
            // get wrinkle extent according to distance change
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_FOREHEAD_CENTER[1], ORIGIN_FOREHEAD_CENTER[1], 
                                        CUR_FOREHEAD_CENTER[0], ORIGIN_FOREHEAD_CENTER[0],
                                        FOREHEAD_FACTOR);                                     
        }
        else if (isLDecreeRegion > 0.5)
        {
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_LMOUTH_CORNER[1], ORIGIN_LMOUTH_CORNER[1], 
                                        CUR_LMOUTH_CORNER[0], ORIGIN_LMOUTH_CORNER[0], 
                                        DECREE_FACTOR);
        }
        else if (isRDecreeRegion > 0.5)
        {
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_RMOUTH_CORNER[1], ORIGIN_RMOUTH_CORNER[1], 
                                        CUR_RMOUTH_CORNER[0], ORIGIN_RMOUTH_CORNER[0],
                                        DECREE_FACTOR);
        }
        // wrinkle factor with full extent
        float full_idensity = tex2D(TEXTURE_WRINKLE, i.uv).r;
        
        // wrinkle factor with current extent
        float cur_wrinkle_factor = lerp(1.0, full_idensity, cur_wrinkle_extent);    
        img_color_yuv.r *= cur_wrinkle_factor;

        // generate final color
        return YUV2RGB(img_color_yuv);
    }
    else
    {
         return tex2D(TEXTURE_DIFFUSE, i.uv);
    } 
}
ENDCG
#END

