#ifndef LIVEPORTRAIT_INC
#define LIVEPORTRAIT_INC

float3 ComputeLight(float3 lightColor, float3 normal, float3 lightDirection, 
                   float3 halfvec,  float3 diffuseRatio, float3 specularRatio,
                   float Shininess)
{
	float lambertIntensity = max(float(dot(normal, lightDirection)), 0.0);
	float3 lambert = diffuseRatio * lambertIntensity * lightColor;

	float phongIntensity = pow(max(dot(normal, halfvec), 0.0), Shininess);
	float3 phong = specularRatio * phongIntensity * lightColor;

	return lambert + phong;
}

float4 RGB2YUV(float4 rgba)
{
    float4x4 RGBtoYUV = float4x4(0.299, 0.587, 0.114,  0.000,
                          -0.1687, -0.3313, 0.5000, 0.5000,
                          0.5, -0.4187, -0.0813,  0.5000,
                          0.5, 0.0,   0.0,  1.0);
                          
    float4 yuv = mul(RGBtoYUV, rgba); 
    return yuv;
}


float4 YUV2RGB(float4 yuv)
{
	float4 rgba;
	rgba.r = yuv.x * 1.0 + yuv.y * 0.0 + (yuv.z - 0.5) * 1.402;
	rgba.g = yuv.x * 1.0 + (yuv.y - 0.5) * -0.34414 + (yuv.z - 0.5) * -0.71414;
	rgba.b = yuv.x * 1.0 + (yuv.y - 0.5) * 1.772 + yuv.z * 0.0;
    rgba.a = yuv.a;
    
    return rgba;
}

float GetCurWrinkleExtent(float3 curPos, float3 origPos, 
                          float3 curRefPos, float3 origRefPos, 
                          float factor)
{
    const float min_proportion = 0.7;
    const float max_proportion = 1.0;

    float orig_distance = distance(origPos, origRefPos);
    float cur_distance = distance(curPos, curRefPos);
    
    float proportion = cur_distance / (orig_distance + 1e-3);
   
    proportion = smoothstep(min_proportion, max_proportion, proportion);
    //proportion = max(min(proportion, 1.0), min_proportion);     // clamped proportion
    
     // range in [0, 1], representing the extent of wrinkle effect
    float cur_wrinkle_extent = (max_proportion - proportion) / (max_proportion - min_proportion);

    // adjust the curve to make the wrinkle effect more natural
    cur_wrinkle_extent = sqrt(cur_wrinkle_extent);
    cur_wrinkle_extent*= factor;
    
    return cur_wrinkle_extent;
}

#endif