#DEFPARAMS
#END

#DEFTAG
ShaderName = "FaceWarp"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
    float2 vertex           : POSITION;
    float2 uv               : TEXCOORD0;
};

struct v2f
{
    float2 uv               : TEXCOORD0;
    float4 vertex           : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
    v2f o;

    o.vertex = UniformNDC(float4(v.vertex, 0.0, 1.0));        
    o.uv = v.uv;
    return o;
}

float4 frag(v2f i) : SV_Target
{
   return tex2D(TEXTURE_DIFFUSE, i.uv);
}
ENDCG
#END

