local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local dolly = {}
dolly.Do = 0;

dolly.Queue = 310;

function dolly:Initialize(host, size)
  
  self.UNIFORM_CENTER =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CENTER");
  self.UNIFORM_SCALE =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SCALE");
  local pathout = venuscore.IFileSystem:PathAssembly("docs:filter/tuijing1/filter/resource/material/windolly.material");  
  self.Do = host:CreateRenderObject(pathout);
  return self.Queue;
end

function dolly:Resizeview(size)
end

function dolly:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Do:Draw(pipeline);
end

return dolly;

