
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_TIME = { "Time", FLOAT, "1.0"},
UNIFORM_XYRATIO = { "XY Ratio", FLOAT, "1.0"},
UNIFORM_RADIUS = { "Radius", VEC3, "1.0,1.0,1.0"},
UNIFORM_WAVEWIDTH = { "Wave Width", FLOAT, "1.0"},
UNIFORM_DISFACTOR = { "Radius", VEC3, "1.0,1.0,1.0"},
UNIFORM_AMPFACTOR = { "Radius", VEC3, "1.0,1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Ripple"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_XYRATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_POINT",
				varType = "float2",
				varSit = "",
				varNum = "3",
				varRegIndex = "0",
				varRegCount = "3",
			},
			{
				varName = "UNIFORM_RADIUS",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_WAVEWIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_DISFACTOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_AMPFACTOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float UNIFORM_TIME;
uniform highp float UNIFORM_XYRATIO;
uniform highp vec2 UNIFORM_POINT[3];
uniform highp vec3 UNIFORM_RADIUS;
uniform highp float UNIFORM_WAVEWIDTH;
uniform highp vec3 UNIFORM_DISFACTOR;
uniform highp vec3 UNIFORM_AMPFACTOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  highp vec2 center_2;
  center_2 = UNIFORM_POINT[0];
  highp vec2 dir_3;
  highp vec2 tmpvar_4;
  tmpvar_4.x = center_2.x;
  tmpvar_4.y = (1.0 - center_2.y);
  highp vec2 tmpvar_5;
  tmpvar_5.x = 1.0;
  tmpvar_5.y = UNIFORM_XYRATIO;
  dir_3 = ((tmpvar_4 - xlv_TEXCOORD0) * tmpvar_5);
  highp float tmpvar_6;
  tmpvar_6 = sqrt(dot (dir_3, dir_3));
  highp vec2 tmpvar_7;
  tmpvar_7 = normalize(dir_3);
  dir_3 = tmpvar_7;
  highp vec2 center_8;
  center_8 = UNIFORM_POINT[1];
  highp vec2 dir_9;
  highp vec2 tmpvar_10;
  tmpvar_10.x = center_8.x;
  tmpvar_10.y = (1.0 - center_8.y);
  highp vec2 tmpvar_11;
  tmpvar_11.x = 1.0;
  tmpvar_11.y = UNIFORM_XYRATIO;
  dir_9 = ((tmpvar_10 - xlv_TEXCOORD0) * tmpvar_11);
  highp float tmpvar_12;
  tmpvar_12 = sqrt(dot (dir_9, dir_9));
  highp vec2 tmpvar_13;
  tmpvar_13 = normalize(dir_9);
  dir_9 = tmpvar_13;
  highp vec2 center_14;
  center_14 = UNIFORM_POINT[2];
  highp vec2 dir_15;
  highp vec2 tmpvar_16;
  tmpvar_16.x = center_14.x;
  tmpvar_16.y = (1.0 - center_14.y);
  highp vec2 tmpvar_17;
  tmpvar_17.x = 1.0;
  tmpvar_17.y = UNIFORM_XYRATIO;
  dir_15 = ((tmpvar_16 - xlv_TEXCOORD0) * tmpvar_17);
  highp float tmpvar_18;
  tmpvar_18 = sqrt(dot (dir_15, dir_15));
  highp vec2 tmpvar_19;
  tmpvar_19 = normalize(dir_15);
  dir_15 = tmpvar_19;
  highp vec2 tmpvar_20;
  tmpvar_20 = (((xlv_TEXCOORD0 + 
    ((tmpvar_7 * ((
      sin(((tmpvar_6 * UNIFORM_DISFACTOR.x) + UNIFORM_TIME))
     * UNIFORM_AMPFACTOR.x) * clamp (
      (1.0 - abs((UNIFORM_RADIUS.x * 1.5)))
    , 0.0, 1.0))) * clamp ((UNIFORM_WAVEWIDTH - abs(
      (UNIFORM_RADIUS.x - tmpvar_6)
    )), 0.0, 1.0))
  ) + (
    (tmpvar_13 * ((sin(
      ((tmpvar_12 * UNIFORM_DISFACTOR.y) + UNIFORM_TIME)
    ) * UNIFORM_AMPFACTOR.y) * clamp ((1.0 - 
      abs((UNIFORM_RADIUS.y * 1.5))
    ), 0.0, 1.0)))
   * 
    clamp ((UNIFORM_WAVEWIDTH - abs((UNIFORM_RADIUS.y - tmpvar_12))), 0.0, 1.0)
  )) + ((tmpvar_19 * 
    ((sin((
      (tmpvar_18 * UNIFORM_DISFACTOR.z)
     + UNIFORM_TIME)) * UNIFORM_AMPFACTOR.z) * clamp ((1.0 - abs(
      (UNIFORM_RADIUS.z * 1.5)
    )), 0.0, 1.0))
  ) * clamp (
    (UNIFORM_WAVEWIDTH - abs((UNIFORM_RADIUS.z - tmpvar_18)))
  , 0.0, 1.0)));
  lowp vec3 tmpvar_21;
  tmpvar_21 = texture2D (TEXTURE_DIFFUSE, tmpvar_20).xyz;
  rgb_1 = tmpvar_21;
  highp vec4 tmpvar_22;
  tmpvar_22.w = 1.0;
  tmpvar_22.xyz = rgb_1;
  gl_FragData[0] = tmpvar_22;
}

]===],
	},
}

end
