#SHADER_DEFINE FaceChangeVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			  HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}

	FUNCTION_OUTPUT = 
	{
  
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,        "out_TexCooridateBag" },
   
	}

#SHADER_CODE
    gl_Position =in_Position;
    vec2 out_TexCooridateBag;
    out_TexCooridateBag=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    //out_TexCooridateBag.y=1.0-out_TexCooridateBag.y;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE FaceChangeFragment

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
    { TEXTURE_BACKG, 		  NONE,	TEXTURE2D,	"in_TextureFaceBack" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,     HIGH,   	VEC2,    	"in_TexCooridateBag" },
  //  { ATTRIBUTE_COORDNATE2, 		HIGH,	VEC2,		"in_TexCooridatestd"},
    { UNIFORM_ALPHACOF, HIGH,	FLOAT,	  "in_alpha" },
	}
	
#SHADER_CODE

    vec4 baseColor = texture2D(in_TextureFace, in_TexCooridateBag);
    vec4 blendColor = texture2D(in_TextureFaceBack, in_TexC);
    //vec4 blendColor = texture2D(in_TextureFaceBack, in_TexCooridatestd);
    // gl_FragColor = blendColor;
    gl_FragColor = vec4(blendColor.rgb,blendColor.a*in_alpha);
   // gl_FragColor = vec4(1.0,1.0,0.0,1.0);

#END_CODE
#END_DEFINE

#SHADER_DEFINE FaceChangeFragment_Split

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		        NONE,	TEXTURE2D,	"in_TextureFace" },
    { TEXTURE_BACKG_RGB,          NONE, TEXTURE2D,  "in_TextureFaceBackRGB" },
    { TEXTURE_BACKG_ALPHA,        NONE, TEXTURE2D,  "in_TextureFaceBackAlpha" },
		{ ATTRIBUTE_COORDNATE0,	      HIGH,	VEC2,	  	  "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,       HIGH, VEC2,     	"in_TexCooridateBag" },
	}
	
#SHADER_CODE

    vec4 baseColor = texture2D(in_TextureFace, in_TexCooridateBag);

    vec3 blendColorRGB = texture2D(in_TextureFaceBackRGB,in_TexC).rgb;
    float blendColorAlpha = texture2D(in_TextureFaceBackAlpha, in_TexC).r;
    vec4 blendColor = vec4(blendColorRGB,blendColorAlpha);
    
    gl_FragColor = blendColor;

#END_CODE
#END_DEFINE



#SHADER_DEFINE FaceChangeVertexStd

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			  HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { ATTRIBUTE_COORDNATE2, 		HIGH,	VEC2,		"in_TexCooridatestd"},
    { UNIFORM_FACETEXPARA,	      HIGH,	VEC4,		"in_facetexpara" },
	}

	FUNCTION_OUTPUT = 
	{
  
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,        "out_TexCooridateBag" },
    { ATTRIBUTE_COORDNATE2, 		HIGH,	VEC2,		"out_TexCooridatestd"},
	}

#SHADER_CODE
    gl_Position =in_Position;
    vec2 out_TexCooridateBag;
    out_TexCooridateBag=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    //out_TexCooridateBag.y=1.0-out_TexCooridateBag.y;
    
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_TexCooridatestd = in_TexCooridatestd.xy*vec2(in_facetexpara.x,in_facetexpara.y)+vec2(in_facetexpara.z,in_facetexpara.w);
#END_CODE
#END_DEFINE


#SHADER_DEFINE FaceChangeFragmentStd

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
    { TEXTURE_BACKG, 		  NONE,	TEXTURE2D,	"in_TextureFaceBack" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,     HIGH,   	VEC2,    	"in_TexCooridateBag" },
    { ATTRIBUTE_COORDNATE2, 		HIGH,	VEC2,		"in_TexCooridatestd"},
    { UNIFORM_ALPHACOF, HIGH,	FLOAT,	  "in_alpha" },
	}
	
#SHADER_CODE

    vec4 baseColor = texture2D(in_TextureFace, in_TexCooridateBag);
    //vec4 blendColor = texture2D(in_TextureFaceBack, in_TexC);
    vec4 blendColor = texture2D(in_TextureFaceBack, in_TexCooridatestd);
    // gl_FragColor = blendColor;
    gl_FragColor = vec4(blendColor.rgb,blendColor.a*in_alpha);
    //gl_FragColor = vec4(1.0,1.0,0.0,1.0);

#END_CODE
#END_DEFINE

#SHADER_DEFINE FaceChangeFragment_SplitStd

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		        NONE,	TEXTURE2D,	"in_TextureFace" },
    { TEXTURE_BACKG_RGB,          NONE, TEXTURE2D,  "in_TextureFaceBackRGB" },
    { TEXTURE_BACKG_ALPHA,        NONE, TEXTURE2D,  "in_TextureFaceBackAlpha" },
		{ ATTRIBUTE_COORDNATE0,	      HIGH,	VEC2,	  	  "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,       HIGH, VEC2,     	"in_TexCooridateBag" },
    { ATTRIBUTE_COORDNATE2, 		HIGH,	VEC2,		"in_TexCooridatestd"},
	}
	
#SHADER_CODE
    vec4 baseColor = texture2D(in_TextureFace, in_TexCooridateBag);
    //vec3 blendColorRGB = texture2D(in_TextureFaceBackRGB,in_TexC).rgb;
    //float blendColorAlpha = texture2D(in_TextureFaceBackAlpha, in_TexC).r;
    vec3 blendColorRGB = texture2D(in_TextureFaceBackRGB,in_TexCooridatestd).rgb;
    float blendColorAlpha = texture2D(in_TextureFaceBackAlpha, in_TexCooridatestd).r;
    vec4 blendColor = vec4(blendColorRGB,blendColorAlpha);
    gl_FragColor = blendColor;

#END_CODE
#END_DEFINE

