
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
TEXTURE_LUT = { "Lut Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "facechangelut"
RenderQueue = "Opaque+100"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_FACETEXPARA",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BACKG",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_LUT",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_ALPHACOF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 UNIFORM_FACETEXPARA;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2.x = _glesVertex.x;
  tmpvar_2.y = -(_glesVertex.y);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = ((vec2(1.0, 1.0) + tmpvar_2) / 2.0);
  xlv_TEXCOORD2 = ((_glesMultiTexCoord2.xy * UNIFORM_FACETEXPARA.xy) + UNIFORM_FACETEXPARA.zw);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_BACKG;
uniform sampler2D TEXTURE_LUT;
uniform highp float UNIFORM_ALPHACOF;
in highp vec2 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 blendColor_1;
  highp vec4 baseColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD1);
  baseColor_2 = tmpvar_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_BACKG, xlv_TEXCOORD2);
  blendColor_1 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = clamp (baseColor_2.xyz, vec3(0.0, 0.0, 0.0), vec3(0.9, 0.9, 0.9));
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = tmpvar_5;
  tmpvar_6.w = baseColor_2.w;
  baseColor_2 = tmpvar_6;
  highp vec2 texPos2_7;
  highp vec2 texPos1_8;
  highp vec2 quad2_9;
  highp vec2 quad1_10;
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_5.z * 15.0);
  quad1_10.y = floor((floor(tmpvar_11) / 4.0));
  quad1_10.x = (floor(tmpvar_11) - (quad1_10.y * 4.0));
  quad2_9.y = floor((ceil(tmpvar_11) / 4.0));
  quad2_9.x = (ceil(tmpvar_11) - (quad2_9.y * 4.0));
  texPos1_8 = (((quad1_10 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * tmpvar_5.xy));
  texPos2_7 = (((quad2_9 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * tmpvar_5.xy));
  highp vec2 tmpvar_12;
  tmpvar_12.x = texPos1_8.x;
  tmpvar_12.y = (1.0 - texPos1_8.y);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (TEXTURE_LUT, tmpvar_12);
  highp vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15.x = texPos2_7.x;
  tmpvar_15.y = (1.0 - texPos2_7.y);
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture (TEXTURE_LUT, tmpvar_15);
  highp vec4 tmpvar_17;
  tmpvar_17 = tmpvar_16;
  highp vec4 tmpvar_18;
  tmpvar_18.xyz = mix (tmpvar_14, tmpvar_17, vec4(fract(tmpvar_11))).xyz;
  tmpvar_18.w = (blendColor_1.w * UNIFORM_ALPHACOF);
  _glesFragData[0] = tmpvar_18;
}

]===],
	},
}

end
