
#DEFPARAMS
PIXEL_OFFSETS = {"PIXEL_OFFSETS", VEC2, "0.0,0.0"},
#END

#DEFTAG
ShaderName = "denoise"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float4 out_SquareCoord01 : TEXCOORD0;
    float4 out_SquareCoord23 : TEXCOORD1;
	float4 out_SquareCoord45 : TEXCOORD2;
	float4 out_SquareCoord67 : TEXCOORD3;
	float2 out_SquareCoord8 : TEXCOORD4;

	float4 vertex : SV_POSITION;
};

float2 PIXEL_OFFSETS;

v2f vert(appdata v)
{
    float4 in_Position = v.in_Position;
	float2 in_TexCoordinate = v.in_Coordinate;
	float2 in_Offsets = PIXEL_OFFSETS;

	v2f o;
	o.vertex = UniformNDC(v.in_Position);

	// first row
    o.out_SquareCoord01.xy = in_TexCoordinate.xy - in_Offsets.xy;     // upper left corner
    o.out_SquareCoord01.zw = float2(in_TexCoordinate.x , in_TexCoordinate.y - in_Offsets.y);
    o.out_SquareCoord23.xy = float2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y - in_Offsets.y);     // upper right corner

    // second row
    o.out_SquareCoord23.zw = float2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y);
    o.out_SquareCoord45.xy = in_TexCoordinate.xy;
    o.out_SquareCoord45.zw = float2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y);

    // thrid row
    o.out_SquareCoord67.xy = float2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y + in_Offsets.y);     // lower left corner
    o.out_SquareCoord67.zw = float2(in_TexCoordinate.x , in_TexCoordinate.y + in_Offsets.y);
    o.out_SquareCoord8.xy = in_TexCoordinate.xy + in_Offsets.xy;     // lower right corner

	return o;
}

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_MASK;

float4 frag(v2f i) : SV_Target
{
	#define uniCurrentTexture TEXTURE_DIFFUSE
	#define in_ColorMask TEXTURE_MASK
	float2 square_coordinates[9];
    square_coordinates[0] = i.out_SquareCoord01.xy;
	square_coordinates[1] = i.out_SquareCoord01.zw;
	square_coordinates[2] = i.out_SquareCoord23.xy;
	square_coordinates[3] = i.out_SquareCoord23.zw;
	square_coordinates[4] = i.out_SquareCoord45.xy;
	square_coordinates[5] = i.out_SquareCoord45.zw;
	square_coordinates[6] = i.out_SquareCoord67.xy;
	square_coordinates[7] = i.out_SquareCoord67.zw;
	square_coordinates[8] = i.out_SquareCoord8.xy;


	half3 curr = tex2D(uniCurrentTexture,square_coordinates[4]).xyz;
    half4 origintex = tex2D(uniCurrentTexture,square_coordinates[4]);

    half3 pre_1 = tex2D(uniCurrentTexture, square_coordinates[0]).xyz;
    half3 post_1 = tex2D(uniCurrentTexture, square_coordinates[8]).xyz;

    half3 pre_2 = tex2D(uniCurrentTexture, square_coordinates[1]).xyz;
    half3 post_2 = tex2D(uniCurrentTexture, square_coordinates[7]).xyz;

    half3 pre_3 = tex2D(uniCurrentTexture, square_coordinates[2]).xyz;
    half3 post_3 = tex2D(uniCurrentTexture, square_coordinates[6]).xyz;

    half3 pre_4 = tex2D(uniCurrentTexture, square_coordinates[3]).xyz;
    half3 post_4 = tex2D(uniCurrentTexture, square_coordinates[5]).xyz;

    half3 diff_1 = post_1 - pre_1;
    half3 sum_1  = post_1 + pre_1;
    half3 diff_2 = post_2 - pre_2;
    half3 sum_2  = post_2 + pre_2;
    half3 diff_3 = post_3 - pre_3;
    half3 sum_3  = post_3 + pre_3;
    half3 diff_4 = post_4 - pre_4;
    half3 sum_4  = post_4 + pre_4;

    half3 var_12 = (curr.xyz * 2.0 - sum_1) / ((diff_1 * diff_1 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_2 * diff_2 * 3000.0) + 8.0);
    half3 var_34 = (curr.xyz * 2.0 - sum_3) / ((diff_3 * diff_3 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_4 * diff_4 * 3000.0) + 8.0);

    curr -= (var_12+var_34);

    half4 tmpColor;
    tmpColor.w = 1.0;
    tmpColor.x = curr.x;
    tmpColor.y = curr.y;
    tmpColor.z = curr.z;

    float4 mask = tex2D(in_ColorMask, float2(square_coordinates[4].x,square_coordinates[4].y));
    float4 outColor = tmpColor*mask.r + origintex*(1.0 - mask.r);

	return outColor;
}

ENDCG
#END