
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_BEZIER = {"TEXTURE_BEZIER", TEXTURE2D, "white"},
UNIFORM_CENTERPOS = {"center pos", VEC2, "1.0,1.0"},
UNIFORM_NEW_CENTERPOS = {"new center pos", VEC2, "1.0,1.0"},
UNIFORM_RATIOASPECT = {"ratio aspect", VEC2, "1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "bezier"
RenderQueue = "Opaque+100"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BEZIER",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_NEW_CENTERPOS",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_RATIOASPECT",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord1;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = (LOCALSCREEN_TRANSVIEWPROJ * _glesVertex);
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (tmpvar_1.xy / tmpvar_1.w);
  xlv_TEXCOORD1 = _glesMultiTexCoord1.x;
  gl_Position = (tmpvar_2 * tmpvar_1);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_BEZIER;
uniform highp vec2 UNIFORM_NEW_CENTERPOS;
uniform highp vec2 UNIFORM_RATIOASPECT;
in highp vec2 xlv_TEXCOORD0;
in highp float xlv_TEXCOORD1;
void main ()
{
  highp vec2 newcenter_1;
  highp vec4 outColor_2;
  highp vec2 in_Pos_3;
  in_Pos_3 = xlv_TEXCOORD0;
  highp float tmpvar_4;
  tmpvar_4 = (UNIFORM_RATIOASPECT.y / UNIFORM_RATIOASPECT.x);
  highp vec2 tmpvar_5;
  tmpvar_5.x = xlv_TEXCOORD0.x;
  tmpvar_5.y = (xlv_TEXCOORD0.y * tmpvar_4);
  newcenter_1.x = UNIFORM_NEW_CENTERPOS.x;
  newcenter_1.y = (UNIFORM_NEW_CENTERPOS.y * tmpvar_4);
  highp float tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (tmpvar_5 - newcenter_1);
  tmpvar_6 = sqrt(dot (tmpvar_7, tmpvar_7));
  if ((tmpvar_6 > 0.0)) {
    highp vec2 texDeformation_8;
    highp float bz_9;
    highp vec2 tmpvar_10;
    tmpvar_10.y = 0.5;
    tmpvar_10.x = xlv_TEXCOORD1;
    lowp float tmpvar_11;
    tmpvar_11 = texture (TEXTURE_BEZIER, tmpvar_10).x;
    bz_9 = tmpvar_11;
    highp vec2 tmpvar_12;
    tmpvar_12 = (((
      normalize((tmpvar_5 - newcenter_1))
     * 
      (tmpvar_6 / xlv_TEXCOORD1)
    ) * bz_9) + newcenter_1);
    texDeformation_8.y = (-(tmpvar_12.y) / tmpvar_4);
    texDeformation_8.x = ((tmpvar_12.x + 1.0) / 2.0);
    texDeformation_8.y = ((texDeformation_8.y + 1.0) / 2.0);
    highp vec2 tmpvar_13;
    tmpvar_13 = clamp (texDeformation_8, vec2(0.01, 0.01), vec2(0.99, 0.99));
    texDeformation_8 = tmpvar_13;
    lowp vec4 tmpvar_14;
    tmpvar_14.w = 1.0;
    tmpvar_14.xyz = texture (TEXTURE_DIFFUSE, tmpvar_13).xyz;
    outColor_2 = tmpvar_14;
  } else {
    in_Pos_3.y = -(xlv_TEXCOORD0.y);
    highp vec2 tmpvar_15;
    tmpvar_15 = ((in_Pos_3 + vec2(1.0, 1.0)) / 2.0);
    lowp vec4 tmpvar_16;
    tmpvar_16.w = 1.0;
    tmpvar_16.xyz = texture (TEXTURE_DIFFUSE, tmpvar_15).xyz;
    outColor_2 = tmpvar_16;
  };
  _glesFragData[0] = outColor_2;
}

]===],
	},
}

end

