
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "nl_reflection"
RenderQueue = "Opaque+100"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD2;
in highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_2 - (2.0 * (
    dot (tmpvar_3, tmpvar_2)
   * tmpvar_3)));
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_REFLECTION, tmpvar_4.xy);
  color_1.xyz = (tmpvar_5 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_6 + color_1);
  _glesFragData[0] = tmpvar_7;
}

]===],
	},
}

end
