
#DEFPARAMS

#END

#DEFTAG
ShaderName  = "face_beauty_test"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float2 in_pos : POSITION;
};

struct v2f
{
    float4 out_pos : SV_POSITION;
    float  out_point_size : PSIZE;
};

v2f vert(appdata v)
{
    v2f o;
    o.out_pos                 = float4(v.in_pos.x, v.in_pos.y, 0.0, 1.0);
    o.out_point_size          = 125.0;
    return o;
}

float4 frag(v2f i) : SV_Target
{
    return float4(1.0, 0.0, 0.0, 1.0);
}

ENDCG
#END