
function DefineParams()
	Properties = 
	{
		
UNIFORM_INPUT_TEXTURE         = {"UNIFORM_INPUT_TEXTURE",         TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
UNIFORM_BLUR_TEXTURE          = {"UNIFORM_BLUR_TEXTURE",          TEXTURE2D, "UNIFORM_BLUR_TEXTURE"},
UNIFORM_BLUR_TEXTURE2         = {"UNIFORM_BLUR_TEXTURE2",         TEXTURE2D, "UNIFORM_BLUR_TEXTURE2"},
UNIFORM_MASK_TEXTURE          = {"UNIFORM_MASK_TEXTURE",          TEXTURE2D, "UNIFORM_MASK_TEXTURE"},
UNIFORM_EYE_MASK_TEXTURE      = {"UNIFORM_EYE_MASK_TEXTURE",      TEXTURE2D, "UNIFORM_EYE_MASK_TEXTURE"},
UNIFORM_TEETH_LOOKUP_TEXTURE  = {"UNIFORM_TEETH_LOOKUP_TEXTURE",  TEXTURE2D, "UNIFORM_TEETH_LOOKUP_TEXTURE"},
UNIFORM_BRIGHT_EYE_STRENGTH   = {"UNIFORM_BRIGHT_EYE_STRENGTH",   FLOAT, "0.0"},
UNIFORM_NAOLABIAL_STRENGTH    = {"UNIFORM_NAOLABIAL_STRENGTH",    FLOAT, "0.0"},
UNIFORM_EYEBAG_STRENGTH       = {"UNIFORM_EYEBAG_STRENGTH",       FLOAT, "0.0"},
UNIFORM_WHITEN_TEETH_STRENGTH = {"UNIFORM_WHITEN_TEETH_STRENGTH", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "face_beauty"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "UNIFORM_INPUT_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BLUR_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BLUR_TEXTURE2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EYE_MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_TEETH_LOOKUP_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BRIGHT_EYE_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_NAOLABIAL_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EYEBAG_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_WHITEN_TEETH_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesVertex.xyz;
  highp vec2 tmpvar_2;
  tmpvar_2.x = (0.5 * (_glesVertex.x + 1.0));
  tmpvar_2.y = (1.0 - (0.5 * (_glesVertex.y + 1.0)));
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.y = 0.0;
  tmpvar_5.x = tmpvar_1.z;
  xlv_TEXCOORD0 = tmpvar_2;
  xlv_TEXCOORD1 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
  xlv_TEXCOORD2 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D UNIFORM_INPUT_TEXTURE;
uniform sampler2D UNIFORM_BLUR_TEXTURE;
uniform sampler2D UNIFORM_BLUR_TEXTURE2;
uniform sampler2D UNIFORM_MASK_TEXTURE;
uniform sampler2D UNIFORM_EYE_MASK_TEXTURE;
uniform sampler2D UNIFORM_TEETH_LOOKUP_TEXTURE;
uniform highp float UNIFORM_BRIGHT_EYE_STRENGTH;
uniform highp float UNIFORM_NAOLABIAL_STRENGTH;
uniform highp float UNIFORM_EYEBAG_STRENGTH;
uniform highp float UNIFORM_WHITEN_TEETH_STRENGTH;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 maskColor_1;
  highp vec3 resultColor_2;
  highp vec4 sourceColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (UNIFORM_INPUT_TEXTURE, xlv_TEXCOORD0);
  sourceColor_3 = tmpvar_4;
  resultColor_2 = sourceColor_3.xyz;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (UNIFORM_MASK_TEXTURE, xlv_TEXCOORD1);
  maskColor_1 = tmpvar_5;
  if ((((maskColor_1.x > 0.01) && (maskColor_1.z < 0.01)) && (UNIFORM_BRIGHT_EYE_STRENGTH >= 0.01))) {
    highp vec4 eyeMaskColor_6;
    highp vec3 sumColor_7;
    lowp vec4 tmpvar_8;
    highp vec2 P_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (xlv_TEXCOORD0 + vec2(-0.008000602, -0.0));
    P_9 = (tmpvar_10 + vec2(-0.0, -0.008000602));
    tmpvar_8 = texture (UNIFORM_INPUT_TEXTURE, P_9);
    sumColor_7 = tmpvar_8.xyz;
    lowp vec4 tmpvar_11;
    highp vec2 P_12;
    P_12 = (tmpvar_10 + vec2(-0.0, -0.004000301));
    tmpvar_11 = texture (UNIFORM_INPUT_TEXTURE, P_12);
    sumColor_7 = (sumColor_7 + tmpvar_11.xyz);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (UNIFORM_INPUT_TEXTURE, tmpvar_10);
    sumColor_7 = (sumColor_7 + tmpvar_13.xyz);
    lowp vec4 tmpvar_14;
    highp vec2 P_15;
    P_15 = (tmpvar_10 + vec2(0.0, 0.004000301));
    tmpvar_14 = texture (UNIFORM_INPUT_TEXTURE, P_15);
    sumColor_7 = (sumColor_7 + tmpvar_14.xyz);
    lowp vec4 tmpvar_16;
    highp vec2 P_17;
    P_17 = (tmpvar_10 + vec2(0.0, 0.008000602));
    tmpvar_16 = texture (UNIFORM_INPUT_TEXTURE, P_17);
    sumColor_7 = (sumColor_7 + tmpvar_16.xyz);
    lowp vec4 tmpvar_18;
    highp vec2 P_19;
    highp vec2 tmpvar_20;
    tmpvar_20 = (xlv_TEXCOORD0 + vec2(-0.004000301, -0.0));
    P_19 = (tmpvar_20 + vec2(-0.0, -0.008000602));
    tmpvar_18 = texture (UNIFORM_INPUT_TEXTURE, P_19);
    sumColor_7 = (sumColor_7 + tmpvar_18.xyz);
    lowp vec4 tmpvar_21;
    highp vec2 P_22;
    P_22 = (tmpvar_20 + vec2(-0.0, -0.004000301));
    tmpvar_21 = texture (UNIFORM_INPUT_TEXTURE, P_22);
    sumColor_7 = (sumColor_7 + tmpvar_21.xyz);
    lowp vec4 tmpvar_23;
    tmpvar_23 = texture (UNIFORM_INPUT_TEXTURE, tmpvar_20);
    sumColor_7 = (sumColor_7 + tmpvar_23.xyz);
    lowp vec4 tmpvar_24;
    highp vec2 P_25;
    P_25 = (tmpvar_20 + vec2(0.0, 0.004000301));
    tmpvar_24 = texture (UNIFORM_INPUT_TEXTURE, P_25);
    sumColor_7 = (sumColor_7 + tmpvar_24.xyz);
    lowp vec4 tmpvar_26;
    highp vec2 P_27;
    P_27 = (tmpvar_20 + vec2(0.0, 0.008000602));
    tmpvar_26 = texture (UNIFORM_INPUT_TEXTURE, P_27);
    sumColor_7 = (sumColor_7 + tmpvar_26.xyz);
    lowp vec4 tmpvar_28;
    highp vec2 P_29;
    P_29 = (xlv_TEXCOORD0 + vec2(-0.0, -0.008000602));
    tmpvar_28 = texture (UNIFORM_INPUT_TEXTURE, P_29);
    sumColor_7 = (sumColor_7 + tmpvar_28.xyz);
    lowp vec4 tmpvar_30;
    highp vec2 P_31;
    P_31 = (xlv_TEXCOORD0 + vec2(-0.0, -0.004000301));
    tmpvar_30 = texture (UNIFORM_INPUT_TEXTURE, P_31);
    sumColor_7 = (sumColor_7 + tmpvar_30.xyz);
    lowp vec4 tmpvar_32;
    tmpvar_32 = texture (UNIFORM_INPUT_TEXTURE, xlv_TEXCOORD0);
    sumColor_7 = (sumColor_7 + tmpvar_32.xyz);
    lowp vec4 tmpvar_33;
    highp vec2 P_34;
    P_34 = (xlv_TEXCOORD0 + vec2(0.0, 0.004000301));
    tmpvar_33 = texture (UNIFORM_INPUT_TEXTURE, P_34);
    sumColor_7 = (sumColor_7 + tmpvar_33.xyz);
    lowp vec4 tmpvar_35;
    highp vec2 P_36;
    P_36 = (xlv_TEXCOORD0 + vec2(0.0, 0.008000602));
    tmpvar_35 = texture (UNIFORM_INPUT_TEXTURE, P_36);
    sumColor_7 = (sumColor_7 + tmpvar_35.xyz);
    lowp vec4 tmpvar_37;
    highp vec2 P_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (xlv_TEXCOORD0 + vec2(0.004000301, 0.0));
    P_38 = (tmpvar_39 + vec2(-0.0, -0.008000602));
    tmpvar_37 = texture (UNIFORM_INPUT_TEXTURE, P_38);
    sumColor_7 = (sumColor_7 + tmpvar_37.xyz);
    lowp vec4 tmpvar_40;
    highp vec2 P_41;
    P_41 = (tmpvar_39 + vec2(-0.0, -0.004000301));
    tmpvar_40 = texture (UNIFORM_INPUT_TEXTURE, P_41);
    sumColor_7 = (sumColor_7 + tmpvar_40.xyz);
    lowp vec4 tmpvar_42;
    tmpvar_42 = texture (UNIFORM_INPUT_TEXTURE, tmpvar_39);
    sumColor_7 = (sumColor_7 + tmpvar_42.xyz);
    lowp vec4 tmpvar_43;
    highp vec2 P_44;
    P_44 = (tmpvar_39 + vec2(0.0, 0.004000301));
    tmpvar_43 = texture (UNIFORM_INPUT_TEXTURE, P_44);
    sumColor_7 = (sumColor_7 + tmpvar_43.xyz);
    lowp vec4 tmpvar_45;
    highp vec2 P_46;
    P_46 = (tmpvar_39 + vec2(0.0, 0.008000602));
    tmpvar_45 = texture (UNIFORM_INPUT_TEXTURE, P_46);
    sumColor_7 = (sumColor_7 + tmpvar_45.xyz);
    lowp vec4 tmpvar_47;
    highp vec2 P_48;
    highp vec2 tmpvar_49;
    tmpvar_49 = (xlv_TEXCOORD0 + vec2(0.008000602, 0.0));
    P_48 = (tmpvar_49 + vec2(-0.0, -0.008000602));
    tmpvar_47 = texture (UNIFORM_INPUT_TEXTURE, P_48);
    sumColor_7 = (sumColor_7 + tmpvar_47.xyz);
    lowp vec4 tmpvar_50;
    highp vec2 P_51;
    P_51 = (tmpvar_49 + vec2(-0.0, -0.004000301));
    tmpvar_50 = texture (UNIFORM_INPUT_TEXTURE, P_51);
    sumColor_7 = (sumColor_7 + tmpvar_50.xyz);
    lowp vec4 tmpvar_52;
    tmpvar_52 = texture (UNIFORM_INPUT_TEXTURE, tmpvar_49);
    sumColor_7 = (sumColor_7 + tmpvar_52.xyz);
    lowp vec4 tmpvar_53;
    highp vec2 P_54;
    P_54 = (tmpvar_49 + vec2(0.0, 0.004000301));
    tmpvar_53 = texture (UNIFORM_INPUT_TEXTURE, P_54);
    sumColor_7 = (sumColor_7 + tmpvar_53.xyz);
    lowp vec4 tmpvar_55;
    highp vec2 P_56;
    P_56 = (tmpvar_49 + vec2(0.0, 0.008000602));
    tmpvar_55 = texture (UNIFORM_INPUT_TEXTURE, P_56);
    sumColor_7 = (sumColor_7 + tmpvar_55.xyz);
    sumColor_7 = (sumColor_7 * 0.04);
    highp vec3 tmpvar_57;
    tmpvar_57 = max (sourceColor_3.xyz, clamp ((sumColor_7 + 
      ((sourceColor_3.xyz - sumColor_7) * 3.0)
    ), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)));
    sumColor_7 = tmpvar_57;
    highp float tmpvar_58;
    tmpvar_58 = (UNIFORM_BRIGHT_EYE_STRENGTH * xlv_TEXCOORD2.x);
    highp vec3 tmpvar_59;
    tmpvar_59 = mix (sourceColor_3.xyz, tmpvar_57, vec3(((tmpvar_58 * 0.5) * maskColor_1.x)));
    lowp vec4 tmpvar_60;
    tmpvar_60 = texture (UNIFORM_EYE_MASK_TEXTURE, xlv_TEXCOORD1);
    eyeMaskColor_6 = tmpvar_60;
    resultColor_2 = mix (mix (tmpvar_59, clamp (
      (((tmpvar_59 * tmpvar_59) * -0.3543) + (1.354 * tmpvar_59))
    , vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)), vec3((
      (eyeMaskColor_6.y * tmpvar_58)
     * 0.5))), clamp ((
      ((tmpvar_59 * tmpvar_59) * 0.3401)
     + 
      (0.6599 * tmpvar_59)
    ), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)), vec3(((eyeMaskColor_6.z * tmpvar_58) * 0.5)));
  } else {
    if (((maskColor_1.y > 0.01) && (UNIFORM_EYEBAG_STRENGTH >= 0.01))) {
      highp vec3 blurColor2_61;
      highp vec3 blurColor1_62;
      lowp vec3 tmpvar_63;
      tmpvar_63 = texture (UNIFORM_BLUR_TEXTURE, xlv_TEXCOORD0).xyz;
      blurColor1_62 = tmpvar_63;
      lowp vec3 tmpvar_64;
      tmpvar_64 = texture (UNIFORM_BLUR_TEXTURE2, xlv_TEXCOORD0).xyz;
      blurColor2_61 = tmpvar_64;
      resultColor_2 = mix (sourceColor_3.xyz, min ((sourceColor_3.xyz + 
        clamp ((((blurColor2_61 - blurColor1_62) * 1.3) + (0.03 * blurColor2_61)), vec3(0.0, 0.0, 0.0), vec3(0.2, 0.2, 0.2))
      ), vec3(1.0, 1.0, 1.0)), vec3((UNIFORM_EYEBAG_STRENGTH * maskColor_1.y)));
    } else {
      if ((((maskColor_1.z > 0.01) && (maskColor_1.x < 0.01)) && (UNIFORM_NAOLABIAL_STRENGTH >= 0.01))) {
        highp vec3 blurColor2_1_65;
        highp vec3 blurColor1_1_66;
        lowp vec3 tmpvar_67;
        tmpvar_67 = texture (UNIFORM_BLUR_TEXTURE, xlv_TEXCOORD0).xyz;
        blurColor1_1_66 = tmpvar_67;
        lowp vec3 tmpvar_68;
        tmpvar_68 = texture (UNIFORM_BLUR_TEXTURE2, xlv_TEXCOORD0).xyz;
        blurColor2_1_65 = tmpvar_68;
        resultColor_2 = mix (sourceColor_3.xyz, min ((sourceColor_3.xyz + 
          clamp ((((blurColor2_1_65 - blurColor1_1_66) * 1.4) + (0.05 * blurColor2_1_65)), vec3(0.0, 0.0, 0.0), vec3(0.3, 0.3, 0.3))
        ), vec3(1.0, 1.0, 1.0)), vec3((UNIFORM_NAOLABIAL_STRENGTH * maskColor_1.z)));
      } else {
        if ((((maskColor_1.z > 0.01) && (maskColor_1.x > 0.01)) && (UNIFORM_WHITEN_TEETH_STRENGTH >= 0.01))) {
          highp vec3 newColor2_69;
          highp vec3 newColor1_70;
          highp vec2 texPos2_71;
          highp vec2 texPos1_72;
          highp vec2 quad2_73;
          highp vec2 quad1_74;
          highp float tmpvar_75;
          tmpvar_75 = (sourceColor_3.z * 15.0);
          quad1_74.y = floor((floor(tmpvar_75) * 0.25));
          quad1_74.x = (floor(tmpvar_75) - (quad1_74.y * 4.0));
          quad2_73.y = floor((ceil(tmpvar_75) * 0.25));
          quad2_73.x = (ceil(tmpvar_75) - (quad2_73.y * 4.0));
          texPos1_72 = (((quad1_74 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * sourceColor_3.xy));
          texPos2_71 = (((quad2_73 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * sourceColor_3.xy));
          lowp vec3 tmpvar_76;
          tmpvar_76 = texture (UNIFORM_TEETH_LOOKUP_TEXTURE, texPos1_72).xyz;
          newColor1_70 = tmpvar_76;
          lowp vec3 tmpvar_77;
          tmpvar_77 = texture (UNIFORM_TEETH_LOOKUP_TEXTURE, texPos2_71).xyz;
          newColor2_69 = tmpvar_77;
          resultColor_2 = mix (sourceColor_3.xyz, mix (newColor1_70, newColor2_69, vec3(fract(tmpvar_75))), vec3((UNIFORM_WHITEN_TEETH_STRENGTH * maskColor_1.z)));
        };
      };
    };
  };
  highp vec4 tmpvar_78;
  tmpvar_78.xyz = resultColor_2;
  tmpvar_78.w = sourceColor_3.w;
  _glesFragData[0] = tmpvar_78;
}

]===],
	},
}

end