local vc = require "venuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"

local ObjectStateWrapper = vc.Object:extend()

local objs = {}

function ObjectStateWrapper:new(obj)
  self.id = obj:GetObjectID()
  if objs[self.id] == nil then
    local info = {}
    info.obj = obj
    info.ref = 1
    info.prevs = {}
    info.currs = {}
    info.nexts = {}
    local props = obj:GetProperties("boolean")
    for _, prop in ipairs(props) do
      info.currs[prop] = info.obj:GetScriptPropValue(prop)
    end
    objs[self.id] = info
  else
    local info = objs[self.id]
    info.ref = info.ref + 1
  end
end

function ObjectStateWrapper:Unref()
  local info = objs[self.id]
  info.ref = info.ref - 1
  if info.ref == 0 then
    objs[self.id] = nil
  end
  self.id = nil
end

function ObjectStateWrapper:GetPrevProp(prop)
  local info = objs[self.id]
  return info.prevs[prop]
end

function ObjectStateWrapper:GetCurrProp(prop)
  local info = objs[self.id]
  return info.currs[prop]
end

function ObjectStateWrapper:GetNextProp(prop)
  local info = objs[self.id]
  return info.nexts[prop]
end

function ObjectStateWrapper:SetNextProp(prop, value)
  local info = objs[self.id]
  info.nexts[prop] = value
end

function ObjectStateWrapper.Reset()
  for id, info in pairs(objs) do
    info.prevs = {}
    info.currs = {}
    info.nexts = {}
    local props = info.obj:GetProperties("boolean")
    for _, prop in ipairs(props) do
      info.currs[prop] = info.obj:GetScriptPropValue(prop)
    end
  end
end

function ObjectStateWrapper.Update()
  for id, info in pairs(objs) do
    local props = info.obj:GetProperties("boolean")
    for _, prop in ipairs(props) do
      info.prevs[prop] = info.currs[prop]
      info.currs[prop] = info.obj:GetScriptPropValue(prop)
      if info.nexts[prop] ~= nil then
        info.currs[prop] = info.nexts[prop]
        info.nexts[prop] = nil
        info.obj:SetScriptPropValue(prop, info.currs[prop])
      end
    end
  end
end

return ObjectStateWrapper

