local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fainted = {}
fainted.FtMat = 0;
fainted.Queue = 118;


function fainted:Initialize(host, size)  
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT"); 
  self.MAX_BIAS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"MAX_BIAS");   
  self.SPEED = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SPEED");   
  self.FtMat = host:CreateMaterial("comm:documents/filter/material/fainted.material" );
  self.FtRO = host:CreateRenderObject()
  self.FtMat:SetParameter(self.COUNT, mathfunction.vector1(0.0));
  self.FtMat:SetParameter(self.MAX_BIAS, mathfunction.vector1(0.05));
  self.FtMat:SetParameter(self.SPEED, mathfunction.vector1(0.5));
  return self.Queue;
end

function fainted:Resizeview(size)
  --self:_SetParam(size);
end

function fainted:Process(context, Original, Scene, Output)  
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.FtMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.FtRO, self.FtMat);
  context:EndRenderPass();
end

return fainted;