local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local mathfunction = require "mathfunction"
local apolloDefine = require "apolloutility.defiend"
local colorspaceconverter = {sRGB_Transfer = nil}

colorspaceconverter.__index = colorspaceconverter;

local _fCreateNode = apollocore.Scene.CreateNode;

function colorspaceconverter:new()
   local new_converter = {};
   setmetatable(new_converter, colorspaceconverter);
   return new_converter;
end

function apollocore.Scene:CreateGenericNode()
  local node = _fCreateNode(self,apollocore.Node.CT_NODE);
  local trans = node:CreateComponent(apollocore.Node.CT_TRANSFORM);
  trans:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));
  return node;
end

function colorspaceconverter:Activate()
  if self.sRGB_Transfer then
    self.sRGB_Transfer.cameraNode.Active = true;
    self.sRGB_Transfer.quadNode.Active = true;
  end
end

function colorspaceconverter:Deactivate()
  if self.sRGB_Transfer then
    self.sRGB_Transfer.cameraNode.Active = false;
    self.sRGB_Transfer.quadNode.Active = false;
  end
end


function colorspaceconverter:Initialize_sRGB_Transfer(scene, isSRGB2Linear, viewSize, layerMask)
  if venuscore.isNil(self.sRGB_Transfer) or venuscore.isNil(self.sRGB_Transfer.quadNode) or venuscore.isNil(self.sRGB_Transfer.cameraNode) then
    self.isCreated = false;
    self.defaultScene = nil;
    self.Scene = nil;
    if scene then
      self.Scene = scene;
    else
      self.defaultScene = apolloengine.SceneManager:GetSceneByType("defaultScene");
      if self.defaultScene == nil then
        self.defaultScene = apolloengine.SceneManager:CreateSceneByType("defaultScene");
        self.isCreated = true;
      end
      self.Scene = self.defaultScene;
    end

    local cameraNode = self.Scene:CreateNode(apolloengine.Node.CT_NODE);
    cameraNode:SetName("sRGB Transfer Camera");
    local cameraComp = cameraNode:CreateComponent(apollocore.Node.CT_CAMERA);
    cameraComp:SetSequenceCulling(true);
    ------------------------------------------------------------------------------------------
    -- initialize fbo
    local rt = apolloengine.RenderTargetEntity();
    rt:PushMetadata(
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(0,0,viewSize:x(),viewSize:y()),
        viewSize));   
    local srgbTex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
    -- initialize srgb Texture   
    srgbTex:PushMetadata(
      apolloengine.TextureBufferMetadata(
        viewSize,
        apolloengine.TextureEntity.TT_TEXTURE2D,
        apolloengine.TextureEntity.TU_WRITE,
        apolloengine.TextureEntity.PF_R8G8B8A8,
        1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        true)); -- sRGB flag   
    rt:CreateResource();
    cameraComp:AttachRenderTarget(rt);
    cameraComp:SetSequenceCulling(true);
    ------------------------------------------------------------------------------------------    
    -- initialize quad render
    local quadNode = self.Scene:CreateNode(apolloengine.Node.CT_NODE);
    quadNode:SetName("sRGB Transfer render");
    local quadRenderComp = quadNode:CreateComponent(apolloengine.Node.CT_RENDER);
    local path = nil;
    if isSRGB2Linear == true then
      path = "comm:documents/material/sRGB2Linear.material";
    else
      path = "comm:documents/material/lineartogamma.material";
    end
    quadRenderComp:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata(path)));
    local flip = false;
    local flat = false;
    quadRenderComp:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,      
      apolloengine.QuadVertexMetadata(flip, flat),
      apolloengine.QuadIndicesMetadata()));
    quadRenderComp:CreateResource();
    ------------------------------------------------------------------------------------------
    -- set up sRGB Transfer pipeline
    local seq = -10050;
    cameraComp:Activate();
    cameraComp:SetSequence(seq);
    cameraComp:SetLayerMaskNothing();
    cameraComp:AddLayerMask(layerMask);
    quadNode:SetLayer(layerMask);
    quadRenderComp:SetSequence(seq);
    ------------------------------------------------------------------------------------------
    self.sRGB_Transfer =
    {
      cameraNode = cameraNode,
      renderTarget = rt,
      texture = srgbTex,
      quadNode = quadNode,
    }
    LOG("sRGB::INITIALIZATION::DONE");
  end
end

function colorspaceconverter:Delete_sRGB_Transfer()
  if not venuscore.isNil(self.sRGB_Transfer) then
    if not venuscore.isNil(apolloengine.Node.CT_CAMERA) and not venuscore.isNil(self.sRGB_Transfer.cameraNode) then
      local cameraComp = self.sRGB_Transfer.cameraNode:GetComponent(apolloengine.Node.CT_CAMERA);
      cameraComp:DetachRenderTarget(self.sRGB_Transfer.renderTarget);
    end
    --local defaultScene = apolloengine.SceneManager:GetOrCreateScene("defaultScene");
    if not venuscore.isNil(self.sRGB_Transfer.cameraNode) then
      self.Scene:DeleteNode(self.sRGB_Transfer.cameraNode);
    end
    if not venuscore.isNil(self.sRGB_Transfer.quadNode) then
      self.Scene:DeleteNode(self.sRGB_Transfer.quadNode);
    end
    self.sRGB_Transfer = nil;
  end
  if self.isCreated == true then
    if self.defaultScene then
      apolloengine.SceneManager:DeleteSceneByID(self.defaultScene:GetStaticID());
    end
  end
end

function colorspaceconverter:SetCamTexEntity(mCamTexEntity)
  if not venuscore.isNil(self.sRGB_Transfer.quadNode) then
    if not venuscore.isNil(apolloengine.Node.CT_RENDER) then
      local renderComp = self.sRGB_Transfer.quadNode:GetComponent(apolloengine.Node.CT_RENDER);
      renderComp:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, mCamTexEntity);
    else
      ERROR("fail to get render component of converter.");
    end
  else
    ERROR("fail to get quadNode of converter.")
  end
end


return colorspaceconverter;