local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local PrintLog = BlueNode:extend();

function PrintLog:new(...)
  PrintLog.super.new(self, ...)
end

function PrintLog:_OnUpdate(args)
  if _KRATOSEDITOR then
    WARNING("PrintLog--"..tostring(args[1]).."--");
  end
end

function PrintLog:_OnCreateWithEditor()
  PrintLog.super._OnCreateWithEditor(self);
end

PrintLog:RegisterInput(1, Types.StringType, "content", "log", "log");

PrintLog:RegisterExecInput(1, "exec", "exec");

PrintLog:RegisterExecOutput(1, "exec", "exec");

PrintLog:SetFunctionName("Print Log");

return PrintLog;

