local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local Vec2MultiFloat = BlueNode:extend();

---- 游戏运行模式
function Vec2MultiFloat:new(...)
  Vec2MultiFloat.super.new(self, ...)
end

function Vec2MultiFloat:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one * two ;
end

---- 编辑器模式

Vec2MultiFloat:RegisterInput(1, mf.vector2:RTTI(), "vector2", "向量(x,y)", mf.vector2(1.0,1.0));
Vec2MultiFloat:RegisterInput(2, Types.FloatType, "scale", "scale", 1.0);
Vec2MultiFloat:RegisterOutput(1, mf.vector2:RTTI(), "multi", "向量数乘 scale * vec(x,y)");
Vec2MultiFloat:SetFunctionName("vector2 * float");
Vec2MultiFloat:SetFunctionType(BD.STATIC_FUNCTION_NODE);


return Vec2MultiFloat;