local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local mf = require "mathfunction"

local ReverseVec3 = BlueNode:extend();

function ReverseVec3:new(...)
  ReverseVec3.super.new(self, ...)
end

function ReverseVec3:_OnUpdate(args)
  local old = args[1]
  return mf.vector3(-old:x(), -old:y(), -old:z()) ;
end

ReverseVec3:RegisterInput(1, mf.vector3:RTTI(), "in", "vector3(x,y,z)", mf.vector3(0.0,0.0,0.0));
ReverseVec3:RegisterOutput(1, mf.vector3:RTTI(), "reverse", "reverse");

ReverseVec3:SetFunctionName("reverse");
ReverseVec3:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return ReverseVec3;

