local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnFrameAniStop = BlueNode:extend();

---- 游戏运行模式
function OnFrameAniStop:new(...)
  OnFrameAniStop.super.new(self, ...)
  self.edge = true;
end

function OnFrameAniStop:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnFrameAniStop:_OnNextBranch() --Update函数调用
  if self.edge and not self.output.isEdge then --设定了边缘触发但不是边缘触发
    return 0
  else
    return 1
  end
end

function OnFrameAniStop:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.FrameAnimationEvent.Stop, func, bluePrintSelf);
end

---- 编辑器模式
OnFrameAniStop:RegisterInput(1, apolloengine.FrameAnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnFrameAniStop:RegisterInput(2, Types.BoolType, "edge", "是否只触发一次", true);
OnFrameAniStop:RegisterExecOutput(1, "OnTrigger", "执行");

OnFrameAniStop:SetFunctionName("_OnFrameAnimationStop");

OnFrameAniStop:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnFrameAniStop:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnFrameAniStop;

