
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local SetLocalRotation = BlueNode:extend();

---- 游戏运行模式
function SetLocalRotation:new(...)
  SetLocalRotation.super.new(self,...)
end

function SetLocalRotation:_OnUpdate(args)
  local transformComponent_target = args[1];
  local qua = args[2];
  transformComponent_target:SetLocalRotation(qua);
  return true;
end


---- 编辑器模式

function SetLocalRotation:GetName()
  return "SetLocalRotation"
end

SetLocalRotation:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "target指向场景中的node", BlueSelf());
SetLocalRotation:RegisterInput(2, mathfunction.Quaternion:RTTI(), "rotate", "设置target在模型坐标系下的姿态", mathfunction.Quaternion());

SetLocalRotation:RegisterExecInput(1, "exec", "执行");

SetLocalRotation:RegisterExecOutput(1, "exec", "执行");

SetLocalRotation:SetFunctionName("SetLocalRotation");



return SetLocalRotation ;
