local AE = require "apolloengine"
local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetLocalEulerAngle = BlueNode:extend();

function SetLocalEulerAngle:new(...)
  SetLocalEulerAngle.super.new(self,...)
end

function SetLocalEulerAngle:_OnUpdate(args)
  local transform  = args[1];
  local isDegree = args[2];
  local vec3 = nil
  if isDegree then
    vec3 = mf.vector3(args[3] *math.pi/180.0, args[4] *math.pi/180.0,  args[5] *math.pi/180.0)
  else
    vec3 = mf.vector3(args[3], args[4], args[5])
  end
  transform.LocalEularAngle = vec3
  return true;
end


SetLocalEulerAngle:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent", BlueSelf());
SetLocalEulerAngle:RegisterInput(2, Types.BoolType, "is degree", "true:degree, false:radian ", true);
SetLocalEulerAngle:RegisterInput(3, Types.FloatType, "x", "x(degree or radian)", 0);
SetLocalEulerAngle:RegisterInput(4, Types.FloatType, "y", "y(degree or radian)", 0);
SetLocalEulerAngle:RegisterInput(5, Types.FloatType, "z", "z(degree or radian)", 0);

SetLocalEulerAngle:RegisterExecInput(1, "exec", "执行");
SetLocalEulerAngle:RegisterExecOutput(1, "exec", "执行");

SetLocalEulerAngle:SetFunctionName("Set Local Euler Angle");


return SetLocalEulerAngle;
