
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"


local GetLocalPositionVec3 = BlueNode:extend();

---- 游戏运行模式
function GetLocalPositionVec3:new(...)
  GetLocalPositionVec3.super.new(self, ...)
end

function GetLocalPositionVec3:_OnUpdate(args)
  local transformComponent_target = args[1];
  local result = transformComponent_target:GetLocalPosition();
  return result;
end

---- 编辑器模式
GetLocalPositionVec3:RegisterOutput(1,  mathfunction.vector3:RTTI(), "vec3", "向量");
GetLocalPositionVec3:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetLocalPositionVec3:SetFunctionName("GetLocalPosition(Vec3)");


return GetLocalPositionVec3 ;

