local apolloengine = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetVertex = BlueNode:extend();

function SetVertex:new(...)
	SetVertex.super.new(self, ...);
end

function SetVertex:_OnUpdate(args)
   
  local renderComponent = args[1]
  local vertexStream = args[2]
  if renderComponent == nil or vertexStream == nil then
    WARNING(string.format("SetVertex: Invalid args: %s %s", tostring(renderComponent), tostring(vertexStream)))
    return
  end
  renderComponent:ChangeVertexBuffer(vertexStream)
end

SetVertex:RegisterInput(1, apolloengine.RenderComponent:RTTI(), "target", "渲染组件", BlueSelf());

SetVertex:RegisterInput(2, apolloengine.VertexStream:RTTI(), "vertex", "顶点", Types.NotNullType());

SetVertex:RegisterExecInput(1, "exec", "Execute");

SetVertex:RegisterExecOutput(1, "exec", "Execute");

SetVertex:SetFunctionName("SetVertex");

return SetVertex;
