local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectBool = SetPostEffectValue:extend();

function SetPostEffectBool:new(...)
  SetPostEffectBool.super.new(self, ...)
end

function SetPostEffectBool:_IsRightType(value)
  return type(value) == "boolean";
end

SetPostEffectBool:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectBool:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);
SetPostEffectBool:RegisterInput(3, Types.BoolType, "ParaValue", "参数值", true);

SetPostEffectBool:RegisterExecInput(1, "exec", "执行");
SetPostEffectBool:RegisterExecOutput(1, "exec", "执行");
SetPostEffectBool:SetFunctionName("SetPostEffectBool");

return SetPostEffectBool;

