local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local TurbulentDisplace = {}

function TurbulentDisplace:Initialize(host, size)
  self.Do = 0;
  self.Queue = 310;
  self.amount = 1;
  self.complexity = 1;
  self.size = 4;
  self.offset = mathfunction.vector2(0,0);
  self.evolution = 0;

  self.AMOUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "AMOUNT");

  self.COMPLEXITY = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "COMPLEXITY");
    
  self.SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIZE");

  self.OFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "OFFSET");

  self.EVOLUTION = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "EVOLUTION");

  self.POST_EFFECT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/turbulentdisplace.material");
  self.DoMat = host:CreateMaterial(pathout);
  self.DoRO = host:CreateRenderObject();
  
  self.DoMat:SetParameter(self.AMOUNT,mathfunction.vector1(self.amount));
  self.DoMat:SetParameter(self.COMPLEXITY,mathfunction.vector1(self.complexity));
  self.DoMat:SetParameter(self.SIZE,mathfunction.vector1(self.size * 0.01));
  self.DoMat:SetParameter(self.OFFSET,self.offset);
  self.DoMat:SetParameter(self.EVOLUTION,mathfunction.vector1(self.evolution));

  self.DoMat:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(1.0));
  
  host:RegisterScriptParameter(self,"amount");
  host:RegisterScriptParameter(self,"complexity");
  host:RegisterScriptParameter(self,"size");
  host:RegisterScriptParameter(self,"offset");
  host:RegisterScriptParameter(self,"evolution");
  return self.Queue;
end



function TurbulentDisplace:Resizeview(size)

end

function TurbulentDisplace:Process(context, Original, Scene, Output)
  self.DoMat:SetParameter(self.AMOUNT,mathfunction.vector1(self.amount));
  self.DoMat:SetParameter(self.COMPLEXITY,mathfunction.vector1(self.complexity));
  self.DoMat:SetParameter(self.SIZE,mathfunction.vector1(self.size * 0.01));
  self.DoMat:SetParameter(self.OFFSET,self.offset);
  self.DoMat:SetParameter(self.EVOLUTION,mathfunction.vector1(self.evolution));
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.DoRO, self.DoMat);
  context:EndRenderPass();
end

return TurbulentDisplace;