local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local bloom = {}
--bloom.RoLumi = 0
--bloom.RoGuassX = 0
--bloom.RoGuassY = 0
--bloom.RoCombine = 0
bloom.RoLumiRenderObj = 0;
bloom.RoGuassXRenderObj = 0;
bloom.RoGuassYRenderObj = 0;
bloom.RoCombineRenderObj = 0;
bloom.RoLumiMaterial = 0;
bloom.RoGuassXMaterial = 0;
bloom.RoGuassYMaterial = 0;
bloom.RoCombineMaterial = 0;

bloom.Rt1 = 0;
bloom.Rt2 = 0;

bloom.Queue = 500;

function bloom:Initialize(host, size)
  
  self.step = mathfunction.vector2( 2.0, 2.0 );
  self.luminace = mathfunction.vector1( 1.0 );
  self.combineweight = mathfunction.vector2( 1.0, 2.0 );
  self.scale1 = mathfunction.vector2( 0.25, 0.25 );
  self.scale2 = mathfunction.vector2( 0.125, 0.125 );
  
  self.COMBINE_WEIRHT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "COMBINE_WEIRHT");
    
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
    
  self.LUMINACE_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LUMINACE_THRESHOLD");
    
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");      
  
  
  self.targetsize = size / 4;
  self.targetsize2 = size / 8;
  local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / self.targetsize;
  
	--self.RoLumi = host:CreateRenderObject( "comm:documents/material/luminance.material" );
	--self.RoLumi:SetParameter(self.LUMINACE_THRESHOLD, mathfunction.vector1( self.luminace:x()) );
  self.RoLumiRenderObj = host:CreateRenderObject();
  self.RoLumiMaterial = host:CreateMaterial("comm:documents/material/luminance.material");
  self.RoLumiMaterial:SetParameter(self.LUMINACE_THRESHOLD, mathfunction.vector1( self.luminace:x()));
	
	--self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	--self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
  self.RoGuassXRenderObj = host:CreateRenderObject();
  self.RoGuassXMaterial = host:CreateMaterial("comm:documents/material/gaussianblur.material");
  self.RoGuassXMaterial:SetParameter(self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ));
	
	--self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	--self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
  self.RoGuassYRenderObj = host:CreateRenderObject();
  self.RoGuassYMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
	self.RoGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
	
	--self.RoCombine = host:CreateRenderObject( "comm:documents/material/combine.material" );
	--self.RoCombine:SetParameter( self.COMBINE_WEIRHT, self.combineweight );
  self.RoCombineRenderObj = host:CreateRenderObject();
  self.RoCombineMaterial = host:CreateMaterial( "comm:documents/material/combine.material" );
	self.RoCombineMaterial:SetParameter( self.COMBINE_WEIRHT, self.combineweight );
	
  self.Rt1 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        self.targetsize));
    
  self.Rt2 = host:CreateRenderTarget( 
     apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        self.targetsize));
    
  self.Rt3 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        self.targetsize2));
    
  self.Rt4 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        self.targetsize2));
  
  host:RegisterScriptParameter(self,"step");
  host:RegisterScriptParameter(self,"luminace");
  host:RegisterScriptParameter(self,"combineweight");
  
  return self.Queue;
end

function bloom:Resizeview(size)
	self.targetsize = size / 4;
	local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / self.targetsize;

	self.RoGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	self.RoGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
end


function bloom:Process(context, Original, Scene, Output)
	
  self:_Updateparameters()
  
	--self.Rt1:PushRenderTarget();
	--self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoLumiMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoLumi:Draw(pipeline);
  context:Draw(self.RoLumiRenderObj, self.RoLumiMaterial);
  context:EndRenderPass();
		
	--self.Rt2:PushRenderTarget();
	--self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassX:Draw(pipeline);
  context:Draw(self.RoGuassXRenderObj, self.RoGuassXMaterial);
  context:EndRenderPass();
		
	--self.Rt1:PushRenderTarget();
	--self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassY:Draw(pipeline);
  context:Draw(self.RoGuassYRenderObj, self.RoGuassYMaterial);
  context:EndRenderPass();
	
	--self.Rt2:PushRenderTarget();
	--self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassX:Draw(pipeline);
  context:Draw(self.RoGuassXRenderObj, self.RoGuassXMaterial);
  context:EndRenderPass();
	
	--self.Rt1:PushRenderTarget();
	--self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassY:Draw(pipeline);	
  context:Draw(self.RoGuassYRenderObj, self.RoGuassYMaterial);
  context:EndRenderPass();
  
  --self.Rt3:PushRenderTarget();
	--self.Rt3:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt3, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassX:Draw(pipeline);	
  context:Draw(self.RoGuassXRenderObj, self.RoGuassXMaterial);
  context:EndRenderPass();
  
  --self.Rt4:PushRenderTarget();
	--self.Rt4:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.Rt4, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoGuassY:Draw(pipeline);	
  context:Draw(self.RoGuassYRenderObj, self.RoGuassYMaterial);
  context:EndRenderPass();
		
	--Output:PushRenderTarget();
	--Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoCombineMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoCombineMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_GLOSSINESS,
		self.Rt4:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	--self.RoCombine:Draw(pipeline);
  context:Draw(self.RoCombineRenderObj, self.RoCombineMaterial);
  context:EndRenderPass();
end

function bloom: _Updateparameters()
    local GuassStep = self.step / self.targetsize;
    self.RoGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
    self.RoGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
    self.RoLumiMaterial:SetParameter(self.LUMINACE_THRESHOLD, mathfunction.vector1( self.luminace:x()) );
    self.RoCombineMaterial:SetParameter( self.COMBINE_WEIRHT, self.combineweight );
end

return bloom;