require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local blackcircles = {}

blackcircles.renderObject = nil;
blackcircles.queue = 100;
blackcircles.eyesmask = nil;
blackcircles.strengh = 0.5;

blackcircles.GaussXYRenderObj = nil;
blackcircles.GaussXYMaterial = nil;
blackcircles.GaussXY2RenderObj = nil;
blackcircles.GaussXY2Material = nil;
blackcircles.BlendRenderObj = nil;
blackcircles.BlendMaterial = nil;

function blackcircles:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(3,3);
  self.Stepsize2 = mathfunction.vector2(7,7);
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_EYEMASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_EYEMASK");
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");



  local GuassStep1 = self.Stepsize1 / size;
  --self.GaussXY = host:CreateRenderObject( "docs:beauty/material/gaussianblurbeauty.material" );
  --self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
  self.GaussXYMaterial = host:CreateMaterial("docs:beauty/material/gaussianblurbeauty.material");
  self.GaussXYRenderObj = host:CreateRenderObject();
  self.GaussXYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );

  local GuassStep2 = self.Stepsize2 / size;
  --self.GaussXY2 = host:CreateRenderObject( "docs:beauty/material/gaussianblurbeauty.material" );
  --self.GaussXY2:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );
  self.GaussXY2Material = host:CreateMaterial("docs:beauty/material/gaussianblurbeauty.material");
  self.GaussXY2RenderObj = host:CreateRenderObject();
  self.GaussXY2Material:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );
  
  --self.Blend = host:CreateRenderObject( "docs:beauty/material/blackeyescircles.material" );
  --self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.BlendMaterial = host:CreateMaterial("docs:beauty/material/blackeyescircles.material");
  self.BlendRenderObj = host:CreateRenderObject();
  self.BlendMaterial:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );

  self.blurRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurRT2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );

  -- abandoned
  --self.eyesmask = apolloengine.TextureEntity();
  --host:RegisterScriptParameter(self,"eyesmask");
  return self.queue;
end

function blackcircles:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  --local GuassStep2 = self.Stepsize2 / size;
  --self.Stepsize2 = mathfunction.vector2(2, 2);
  self.size = size;
  --self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
  self.GaussXYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
  --self.GaussXY2:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );
  self.GaussXY2Material:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );

end

function blackcircles:Process(context, Original, Scene, Output)
  
  self:_UpdateParameters();
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  

  
  --self.blurRT1:PushRenderTarget();
  --self.blurRT1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  --self.GaussXY:SetParameter(
  --  apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --  origintexture);
  --self.GaussXY:Draw(pipeline); --高斯模糊1

  context:BeginRenderPass(self.blurRT1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GaussXYMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    origintexture);
  context:Draw(self.GaussXYRenderObj, self.GaussXYMaterial);
  context:EndRenderPass();  --高斯模糊1


  --self.blurRT2:PushRenderTarget();
  --self.blurRT2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  --self.GaussXY2:SetParameter(
  --  apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --  self.blurRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  --self.GaussXY2:Draw(pipeline); --高斯模糊2

  context:BeginRenderPass(self.blurRT2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.GaussXY2Material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.blurRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.GaussXY2RenderObj, self.GaussXY2Material);
  context:EndRenderPass();  --高斯模糊2

  
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  --self.Blend:SetParameter(self.TEXTURE_ORIGIN,origintexture);
  --self.Blend:SetParameter(self.TEXTURE_EYEMASK,self.eyesmask);
  --self.Blend:SetParameter(
  --  apolloengine.ShaderEntity.TEXTURE_SPECULAR,
  --  self.blurRT2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  --self.Blend:Draw(pipeline);

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.BlendMaterial:SetParameter(self.TEXTURE_ORIGIN,origintexture);
  self.BlendMaterial:SetParameter(self.TEXTURE_EYEMASK,self.eyesmask);
  self.BlendMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_SPECULAR,
    self.blurRT2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.BlendRenderObj, self.BlendMaterial);
  context:EndRenderPass();
  
end

function blackcircles:_UpdateParameters()
  --self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.BlendMaterial:SetParameter(self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh));
end

return blackcircles;