local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local libmasquerade = require "libmasquerade"
local cv = require "computervisionfunction"


local FaceImage = venuscore.VenusBehavior:extend("FaceImageBehavior");

local config = {
  use_persp = true;
  bin = "bigo_low_cereal.bin";
  config = "bilinear_config.json";
  global = "bilinear_global.json";
  rigid_prior = "AdaptiveRigidPriorPersp.json"
}



function FaceImage:new()
  self.renderInited = false
  self.recogition=nil;
  self.isshow = nil;
  self.needReset = false;
  self.point = 683;
  self.headIndex = 1;
  self.camera = self.Node:GetHostScene():GetMainCamera();
  self.recognition = nil;
  self.attach = nil;
end

function FaceImage:GetCombo()
  return self.point;
end

function FaceImage:SetCombo(value)
  self.point = value;
end

function FaceImage:GetHeadIndex()
  return self.headIndex;
end

function FaceImage:SetHeadIndex(value)
  self.headIndex = value;
end

function FaceImage:GetRecongnition()
  if self.recognition==nil then
    self.recognition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);
    if self.recognition==nil then
      LOG("[Bilinear]: WE HAVE NO RECOGNITION COMPOENENT!")
    end
  end
  return self.recognition;
end

function FaceImage:SetRecongnition(rec)
  LOG("[Bilinear]: SET REC")
  self.recognition = rec;
end

function FaceImage:GetAttach()
  if self.attach==nil or venuscore.isNil(self.attach) then
    local childs = self.Node:GetChildrens();
    for i = 1, #childs do
      if childs[i]:GetName() == "image"
              and childs[i]:GetComponent(apolloengine.Node.CT_RENDER)
              and childs[i]:GetComponent(apolloengine.Node.CT_TRANSFORM)
      then
        self.attach = childs[i]:GetComponent(apolloengine.Node.CT_TRANSFORM);
      end
    end
    if self.attach==nil or venuscore.isNil(self.attach) then
      LOG("[Bilinear]: WE HAVE NO ATTACH!")
      self.attach = nil;
    end
  end
  return self.attach;
end

function FaceImage:SetAttach(rec)
  LOG("[Bilinear]: SET ATTACH")
  self.attach = rec;
end

function FaceImage:GetCamera()
  return  self.camera;
end

function FaceImage:SetCamera(value)
  self.camera = value;
end

function FaceImage:GetTransform()
  if self.transform==nil then
    self.transform = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
    if self.transform==nil then
      LOG("[Bilinear]: WE HAVE NO TRANSFORM COMPOENENT!")
    end
  end
  return  self.transform;
end

function FaceImage:GetRender()
  if self.render==nil then
    self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
    if self.render==nil then
      LOG("[Bilinear]: WE HAVE NO RENDER COMPOENENT!")
    end
  end
  return  self.render;
end

function FaceImage:GetResolution()
  local camera = self:GetCamera();
  if camera~=nil then
    local res = camera.CameraResolution;
    return res
  end
  return nil
end


function FaceImage:_Play()

end

function FaceImage:_OnAwake()

end

function FaceImage:_OnStart()

end

function FaceImage:Init()
  if self:GetCamera() ~= nil then
    local resolution = self:GetResolution();
    self.bilinearTracking = libmasquerade.BilinearTracking();
    --self.bilinearTracking:EnableLog();
    if self.bilinearTracking:Init(
            resolution:x(), resolution:y(), config.use_persp,
            config.config,
            config.bin,
            config.global,
            config.rigid_prior) then
      --self.bilinearTracking:SetSmoothing(false)
      --self.bilinearTracking:SetPosit(false)
      self.bilinearTracking:EnableDynamicUser(true, false)
      LOG("[Bilinear]: INIT DONE");
      self.isInited = true
      return true
    else
      self.isInited = false
      ERROR("[Bilinear]: fail to init bilinear tracking.")
    end
  end
  return false
end

function FaceImage:GetFaceData()
  --LOG("[Bilinear]: Update lmk");
  if self:GetRecongnition()==nil then
    LOG("[Bilinear]: NO REC");
    return nil;
  end
  local results = self:GetRecongnition():GetResult();
  if results==nil or results[cv.RecognitionComponent.cvFace]==nil then
    LOG("[Bilinear]: NO RESULT");
    return nil;
  end

  local faceData = {}

  local facerets = results[cv.RecognitionComponent.cvFace][self.headIndex];
  if facerets==nil then
    return nil;
  end
  --LOG("[Bilinear]: Update face lmk");
  local lmk = {}
  for i = 1, 106 do
    lmk[i * 2 - 1] = facerets[i * 2 - 1]
    lmk[i * 2] = facerets[i * 2]
  end

  local advFacerets = results[cv.RecognitionComponent.cvAdvancedLandmark];
  local useAdv = false
  if advFacerets ~= nil and advFacerets[self.headIndex] ~= nil and advFacerets[self.headIndex][107 * 2 - 1] >= 0 then
    for i = 107, 240 do
      lmk[i * 2 - 1] = advFacerets[self.headIndex][i * 2 - 1]
      lmk[i * 2] = advFacerets[self.headIndex][i * 2]
    end
    useAdv = true
    --lmk[85 * 2 - 1] = advFacerets[1][(106 + 71) * 2 - 1];
    --lmk[85 * 2] = advFacerets[1][(106 + 71) * 2];
    --lmk[86 * 2 - 1] = advFacerets[1][(106 + 74) * 2 - 1];
    --lmk[86 * 2] = advFacerets[1][(106 + 74) * 2];
    --lmk[87 * 2 - 1] = advFacerets[1][(106 + 77) * 2 - 1];
    --lmk[87 * 2] = advFacerets[1][(106 + 77) * 2];
    --lmk[88 * 2 - 1] = advFacerets[1][(106 + 79) * 2 - 1];
    --lmk[88 * 2] = advFacerets[1][(106 + 79) * 2];
    --lmk[89 * 2 - 1] = advFacerets[1][(106 + 81) * 2 - 1];
    --lmk[89 * 2] = advFacerets[1][(106 + 81) * 2];
    --lmk[90 * 2 - 1] = advFacerets[1][(106 + 84) * 2 - 1];
    --lmk[90 * 2] = advFacerets[1][(106 + 84) * 2];
    --lmk[91 * 2 - 1] = advFacerets[1][(106 + 87) * 2 - 1];
    --lmk[91 * 2] = advFacerets[1][(106 + 87) * 2];
    --lmk[92 * 2 - 1] = advFacerets[1][(106 + 131) * 2 - 1];
    --lmk[92 * 2] = advFacerets[1][(106 + 131) * 2];
    --lmk[93 * 2 - 1] = advFacerets[1][(106 + 129) * 2 - 1];
    --lmk[93 * 2] = advFacerets[1][(106 + 129) * 2];
    --lmk[94 * 2 - 1] = advFacerets[1][(106 + 127) * 2 - 1];
    --lmk[94 * 2] = advFacerets[1][(106 + 127) * 2];
    --lmk[95 * 2 - 1] = advFacerets[1][(106 + 125) * 2 - 1];
    --lmk[95 * 2] = advFacerets[1][(106 + 125) * 2];
    --lmk[96 * 2 - 1] = advFacerets[1][(106 + 123) * 2 - 1];
    --lmk[96 * 2] = advFacerets[1][(106 + 123) * 2];
    --lmk[97 * 2 - 1] = advFacerets[1][(106 + 88) * 2 - 1];
    --lmk[97 * 2] = advFacerets[1][(106 + 88) * 2];
    --lmk[98 * 2 - 1] = advFacerets[1][(106 + 93) * 2 - 1];
    --lmk[98 * 2] = advFacerets[1][(106 + 93) * 2];
    --lmk[99 * 2 - 1] = advFacerets[1][(106 + 96) * 2 - 1];
    --lmk[99 * 2] = advFacerets[1][(106 + 96) * 2];
    --lmk[100 * 2 - 1] = advFacerets[1][(106 + 99) * 2 - 1];
    --lmk[100 * 2] = advFacerets[1][(106 + 99) * 2];
    --lmk[101 * 2 - 1] = advFacerets[1][(106 + 104) * 2 - 1];
    --lmk[101 * 2] = advFacerets[1][(106 + 104) * 2];
    --lmk[102 * 2 - 1] = advFacerets[1][(106 + 115) * 2 - 1];
    --lmk[102 * 2] = advFacerets[1][(106 + 115) * 2];
    --lmk[103 * 2 - 1] = advFacerets[1][(106 + 112) * 2 - 1];
    --lmk[103 * 2] = advFacerets[1][(106 + 112) * 2];
    --lmk[104 * 2 - 1] = advFacerets[1][(106 + 109) * 2 - 1];
    --lmk[104 * 2] = advFacerets[1][(106 + 109) * 2];
    --LOG("[Bilinear]: USE ADV FACE LANDMARKS")
  else
    for i = 107, 240 do
      lmk[i * 2 - 1] = -1
      lmk[i * 2] = -1
    end
  end

  faceData.useAdv = useAdv
  faceData.landmarks = lmk

  local visibility = {}
  for i = 112, 217 do
    visibility[i - 111] = facerets[i * 2 - 1]
  end
  faceData.visibility = visibility

  local pyr = {}
  pyr[1] = facerets[109 * 2 - 1]
  pyr[2] = facerets[110 * 2 - 1]
  pyr[3] = facerets[111 * 2 - 1]
  faceData.euler = mathfunction.vector3(pyr[1], pyr[2], pyr[3])

  local tongue = results[cv.RecognitionComponent.cvTongueDetection]
  faceData.tongue = 0
  if tongue ~= nil and tongue[self.headIndex] ~= nil then
    faceData.tongue = tongue[self.headIndex][1]
  end

  local iris = results[cv.RecognitionComponent.cvIrisDetection]
  local leftEye = mathfunction.vector2(0, 0)
  local rightEye = mathfunction.vector2(0, 0)
  if iris ~= nil and iris[self.headIndex] ~= nil then
    leftEye = mathfunction.vector2(iris[self.headIndex][20 * 2 - 1], iris[self.headIndex][20 * 2])
    rightEye = mathfunction.vector2(iris[self.headIndex][40 * 2 - 1], iris[self.headIndex][40 * 2])
  end
  if leftEye:x() == 0 and leftEye:y() == 0 then
    leftEye = mathfunction.vector2(facerets[105 * 2 - 1], facerets[105 * 2])
  end
  if rightEye:x() == 0 and rightEye:y() == 0 then
    rightEye = mathfunction.vector2(facerets[106 * 2 - 1], facerets[106 * 2])
  end
  faceData.leftEye = leftEye
  faceData.rightEye = rightEye
  return faceData
end

function FaceImage:Positioning()
  local trans = self.bilinearTracking:GetTranslation()
  local rot = self.bilinearTracking:GetRotation()
  if trans == nil or rot == nil then
    return false;
  end
  local pos = {}
  pos.rotation = rot:ToQuaternion()
  pos.position = trans

  local transform = self:GetTransform();
  if transform then
    transform:SetLocalPosition(pos.position);
    transform:SetLocalRotation(pos.rotation);
  end
  return true
end

function FaceImage:UpdateMesh(tracking_data)
  local local2world = self:GetTransform():GetWorldTransform();
  local worldPosition = nil;
  local newpoint =  mathfunction.vector4(0, 0, 0, 1)
  local vtxnum = #tracking_data.vertices / 3
  local scale = self.bilinearTracking:GetScale()
  for i = 1, vtxnum do
    newpoint:Set(tracking_data.vertices[i * 3 - 2] * scale, tracking_data.vertices[i * 3 - 1] * scale, tracking_data.vertices[i * 3] * scale , 1)
    if i == self.point then
      worldPosition = newpoint * local2world;
    end
  end

  if self:GetAttach() ~= nil and worldPosition ~= nil then
    local newpos = mathfunction.vector3(worldPosition:x(),worldPosition:y(),worldPosition:z());
    --LOG("worldPos = " .. newpos:x() .. "_".. newpos:y() .. "_".. newpos:z());
    self:GetAttach():SetWorldPosition(newpos);
  end
end

function FaceImage:_OnUpdate(timespan)
  if self.isInited ~= true then
    if not self:Init() then
      return
    end
  end

  local facedata = self:GetFaceData()
  if facedata == nil then
    ERROR("[Bilinear]: fail to get face data.");
    self.needReset = true
    return
  end

  local camera = self:GetCamera()
  if camera == nil then
    return
  end

  if self.needReset then
    self.bilinearTracking:Reset()
    self.needReset = false
  end

  local proj = camera:GetProject()
  local resolution = self:GetResolution()
  if proj == nil or self.bilinearTracking:SetProjMat(resolution:x(), resolution:y(), proj) ~= true then
    LOG("[Bilinear]: Use default projection matrix of Bilinear Model.")
  end

  if not self.bilinearTracking:Track(facedata.useAdv, facedata.euler, facedata.landmarks, facedata.visibility, facedata.leftEye, facedata.rightEye, facedata.tongue) then
    ERROR("[Bilinear]: fail to track.");
    return
  end

  if not self:Positioning() then
    ERROR("[Bilinear]: fail to set mesh location.");
    return
  end

  local trackingresult = {}
  trackingresult.vertices = self.bilinearTracking:GetTrackingVertices()
  self:UpdateMesh(trackingresult)
  --LOG("Update mesh")
end

FaceImage:MemberRegister("headindex",
        venuscore.ScriptTypes.ComboType(
                {
                  {
                    key = "1",
                    value = 1
                  },
                  {
                    key = "2",
                    value = 2
                  },
                  {
                    key = "3",
                    value = 3
                  },
                },
                FaceImage.GetHeadIndex,
                FaceImage.SetHeadIndex
        ));

FaceImage:MemberRegister("point",
        venuscore.ScriptTypes.ComboType(
                {
                  {
                    key = "Mouth",
                    value = 683
                  },
                  {
                    key = "Lefteye",
                    value = 315
                  },
                  {
                    key = "Righteye",
                    value = 1000
                  },
                  {
                    key = "Forehead",
                    value = 407
                  },
                },
                FaceImage.GetCombo,
                FaceImage.SetCombo
        ));
--[[
FaceImage:MemberRegister("camera",
        venuscore.ScriptTypes.ReferenceType(
                apolloengine.CameraComponent:RTTI(),
                FaceImage.GetCamera,
                FaceImage.SetCamera
        ));

FaceImage:MemberRegister("recognition",
        venuscore.ScriptTypes.ReferenceType(
                cv.RecognitionComponent:RTTI(),
                FaceImage.GetRecongnition,
                FaceImage.SetRecongnition
        ));

FaceImage:MemberRegister("attach",
        venuscore.ScriptTypes.ReferenceType(
                apolloengine.TransformComponent:RTTI(),
                FaceImage.GetAttach,
                FaceImage.SetAttach
        ));
]]--

return FaceImage;