

#DEFPARAMS
_MainTex = {"main Color", TEXTURE2D, "white" },
_MaskTex = {"Move Mask", TEXTURE2D, "white"},
_Phase = { "Wave Phase", FLOAT, "0.02"},
_OffsetMount = {"Offset Mount", FLOATRANGE, "0.0, 1.0, 0.0"},
_FrameIndex = { "Frame Index", FLOAT , "1.0"},
_RegionCount = { "Frames Count", FLOAT, "4.0"},
#END

#DEFTAG
ShaderName = "WaveFilter"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float offsetMount : TEXCOORD1;
	float maskUOffset : TEXCOORD2;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _MaskTex;
SamplerState _MainSampler;
SamplerState _MaskSampler;
float _Phase;
float _OffsetMount;
float _FrameIndex;
float _RegionCount;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex); 
	o.uv = v.uv.xy;
	o.offsetMount = sin(3.14159265 * _OffsetMount);
	o.maskUOffset = 1.0 / _RegionCount * ((int)(_FrameIndex) + 0.5);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 maskUV = float2(i.maskUOffset, i.uv.y);
	float2 maskCol = _MaskTex.Sample(_MaskSampler, maskUV).rg;
	// 1 向右移动 -1向左移动 0不移动
	float moveDir = dot(float2(1.0, -1.0), maskCol.rg);

	moveDir = (moveDir > 0.0 ? 1.0 : moveDir);
	moveDir = (moveDir < 0.0 ? -1.0 : moveDir);

	float offset = i.offsetMount * _Phase * moveDir;
	// sample the texture
	mainColor = _MainTex.Sample(_MainSampler, float2(i.uv.x + offset, i.uv.y));
}
ENDCG
#END
