
#DEFPARAMS
SHINE_TEXTURE = { "Shine Tex", TEXTURE2D, "0.0,0.0" },
BLUR_RADIUS = { "Radius", FLOAT, "0.0" },
UNIFORM_OFFSET = { "Offset", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "ShineLightBlur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D SHINE_TEXTURE;
SamplerState SHINE_TEXTURE_Sampler;
float BLUR_RADIUS;
float2 UNIFORM_OFFSET;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	int radius = int(BLUR_RADIUS);
	float2 cur_pos = i.uv - UNIFORM_OFFSET * float(radius);
	
	int total = radius * 2 + 1;
	float4 sum = float4(0.0, 0.0, 0.0, 0.0);

	for (int i = 0; i < total; i++)
	{
		sum += SHINE_TEXTURE.Sample(SHINE_TEXTURE_Sampler, cur_pos);
		cur_pos += UNIFORM_OFFSET;
	}
	
	sum /= float(total);
	
	mainColor = sum;
}
ENDCG
#END
