#SHADER_DEFINE InvertVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE InvertFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
        { BLEND_FACTOR,              MEDIUM,    FLOAT,       "in_blend" },
    }

#SHADER_CODE

    vec3 c1 = texture2D(in_DiffuseTexture, in_TexCoordinate).rgb;
    vec3 c2 = c1 * in_blend + (vec3(1.0, 1.0, 1.0) - c1) * (1.0 - in_blend);
    
    gl_FragColor = vec4(c2, 1.0);

#END_CODE
#END_DEFINE







