//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


#SHADER_DEFINE Texture2DSampling

  FUNCTION_INPUT =
  {
      { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
			{ TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
  }
  FUNCTION_OUTPUT =
  {
      { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"}
  }
#SHADER_CODE
	vec3 diffuseColor = texture2D(diffuseMap, in_Coordinate).rgb;
#END_CODE
#END_DEFINE


/计算头发的直接光照
#SHADER_DEFINE HairLighting

  FUNCTION_INPUT =
  {
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,            LOW,  VEC3,           "ambientColor"},
		{ R_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_r" },
		{ TRT_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_trt" },
		{ TT_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_tt" },
		{ DIFFUSE_SCALE,        	  MEDIUM,   FLOAT,        "am_d" },
		{ R_SPEC_POW,      		    MEDIUM,   FLOAT,       "reflectwidth" },
		{ TRT_SPEC_POW,          MEDIUM,   FLOAT,        "trtwidth" },
		{ TT_SPEC_POW,         	 MEDIUM,   FLOAT,        "ttwidth" },
		{ LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
  }
  FUNCTION_OUTPUT =
  {
		{ LIGHTING_DIFFUSE,			LOW,	VEC3,	    		"light_Diffuse" },
    { LIGHTING_SPECULAR,			LOW,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

	lightDirection = -lightDirection;

	vec3 tangent = tangentDir;

	float lightVec = dot(lightDirection, tangent);
	float viewVec = dot(viewDirection, tangent);

	float thetah = (asin(lightVec) + asin(viewVec)) / 2;
	float cosphi = dot(normalize(lightDirection - lightVec*tangent),
										normalize(viewDirection - viewVec*tangent));

	// R component
	vec3 reflection = vec3(clamp(am_r*pow(abs(cos(thetah-am_r)), reflectwidth), 0.0, 1.0));

	// TRT component
	vec3 treft = vec3(clamp(am_trt*pow(abs(cos(thetah-am_trt)), trtwidth), 0.0, 1.0));

	// TT component
	vec3 ttransmit = vec3(clamp(am_tt*pow(abs(cos(thetah-am_tt)), ttwidth), 0.0, 1.0));

	vec3 light_Specular = reflection + treft + ttransmit;
	light_Specular *= lightColor;

	vec3 light_Diffuse = clamp(am_d * sqrt(min(1.0, dot(lightVec, lightVec))), 0.0, 1.0) * diffuseColor;
	light_Diffuse *= lightColor;

  vec3 ambient = ambientColor * lightColor;

#END_CODE
#END_DEFINE


//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
      { LIGHTING_AMBIENT,          LOW,  VEC3,   "ambient"},
			{ SPECULAR_SCALE,        	  MEDIUM,   FLOAT,        "specscale" }
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		vec3 color =  light_Specular * specscale + light_Diffuse + ambient;

		gl_FragColor = vec4(color,1.0);

#END_CODE
#END_DEFINE

//====================================================================================加入阴影
/计算头发的直接光照
#SHADER_DEFINE HairLightingShadow

  FUNCTION_INPUT =
  {
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,            LOW,  VEC3,           "ambientColor"},
		{ R_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_r" },
		{ TRT_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_trt" },
		{ TT_SPEC_STRENGTH,          MEDIUM,   FLOAT,        "am_tt" },
		{ DIFFUSE_SCALE,        	  MEDIUM,   FLOAT,        "am_d" },
		{ R_SPEC_POW,      		    MEDIUM,   FLOAT,       "reflectwidth" },
		{ TRT_SPEC_POW,          MEDIUM,   FLOAT,        "trtwidth" },
		{ TT_SPEC_POW,         	 MEDIUM,   FLOAT,        "ttwidth" },
		{ LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
    { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
  }
  FUNCTION_OUTPUT =
  {
		{ LIGHTING_DIFFUSE,			LOW,	VEC3,	    		"light_Diffuse" },
    { LIGHTING_SPECULAR,			LOW,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

	lightDirection = -lightDirection;

	vec3 tangent = tangentDir;

	float lightVec = dot(lightDirection, tangent);
	float viewVec = dot(viewDirection, tangent);

	float thetah = (asin(lightVec) + asin(viewVec)) / 2;
	float cosphi = dot(normalize(lightDirection - lightVec*tangent),
										normalize(viewDirection - viewVec*tangent));

	// R component
	vec3 reflection = vec3(clamp(am_r*pow(abs(cos(thetah-am_r)), reflectwidth), 0.0, 1.0));

	// TRT component
	vec3 treft = vec3(clamp(am_trt*pow(abs(cos(thetah-am_trt)), trtwidth), 0.0, 1.0));

	// TT component
	vec3 ttransmit = vec3(clamp(am_tt*pow(abs(cos(thetah-am_tt)), ttwidth), 0.0, 1.0));
  
  vec3 newlightColor = mix(lightColor,in_TransparentColor.xyz,in_TransparentColor.a);
  
	vec3 light_Specular = reflection + treft + ttransmit;
	light_Specular *= newlightColor;

	vec3 light_Diffuse = clamp(am_d * sqrt(min(1.0, dot(lightVec, lightVec))), 0.0, 1.0) * diffuseColor;
	light_Diffuse *= newlightColor;

  vec3 ambient = ambientColor * newlightColor;

#END_CODE
#END_DEFINE

