//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


#SHADER_DEFINE Texture2DSampling

  FUNCTION_INPUT =
  {
      { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
      { WORLDSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
      { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
			{ TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
      { TEXTURE_BUMP,					  NONE,			TEXTURE2D,		"normalMap" },
      { TEXTURE_SPECULAR,			  NONE,			TEXTURE2D,		"specularMap" },
  }
  FUNCTION_OUTPUT =
  {
      { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
			{ LIGHTING_SPECULAR,         MEDIUM,   VEC3,         "specColor"},
			{ TANGENT_NORMAL,						 MEDIUM,   VEC3,				 "tangentNormal"},
  }

#SHADER_CODE

	vec3 diffuseColor = texture2D(diffuseMap, in_Coordinate).rgb;

	vec3 tangentNormal;
	{
		vec3 tangentNormal_tmp = texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0;
		tangentNormal_tmp.xy *= 0.2;
		tangentNormal_tmp.z = sqrt(1.0 - clamp(dot(tangentNormal_tmp.xy, tangentNormal_tmp.xy), 0.0, 1.0));
		tangentNormal = normalize(tangentNormal_tmp);
	}
	vec3 specColor = texture2D(specularMap, in_Coordinate).rgb;

#END_CODE
#END_DEFINE


/计算头发的直接光照
#SHADER_DEFINE HairLighting

  FUNCTION_INPUT =
  {
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,            LOW,  VEC3,           "ambientColor"},
		{ PRIMARY_SPEC_COLOR,          MEDIUM,   VEC3,        "primColor" },
		{ SECONDARY_SPEC_COLOR,          MEDIUM,   VEC3,        "secdColor" },
		{ PRIMARY_SPEC_POWER,          MEDIUM,   FLOAT,        "primPow" },
		{ SECONDARY_SPEC_POWER,          MEDIUM,   FLOAT,       "secdPow" },
		{ PRIMARY_SPEC_SHIFT,          MEDIUM,   FLOAT,        "primShift" },
		{ SECONDARY_SPEC_SHIFT,          MEDIUM,   FLOAT,        "secdShift" },
		{ LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
		{ LIGHTING_SPECULAR,         MEDIUM,   VEC3,         "specColor"},
		{ TANGENT_NORMAL,						 MEDIUM,   VEC3,				 "tangentNormal"},
  }
  FUNCTION_OUTPUT =
  {
		{ LIGHTING_DIFFUSE,			LOW,	VEC3,	    		"light_Diffuse" },
    { LIGHTING_SPECULAR,			LOW,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

	vec3 tangent = tangentDir;

	float shift = specColor.g;
	// 计算切线方向的偏移度
	vec3 stangent1;
	{
		stangent1 = normalize(tangent + (primShift+shift) * tangentNormal);
	}
	vec3 stangent2;
	{
		stangent2 = normalize(tangent + (secdShift+shift) * tangentNormal);
	}

	// 这里的光源方向需要指向光源
  lightDirection = -lightDirection;

	vec3 vHalf = normalize(lightDirection + viewDirection);
	vec3 spec1;
	{
		float dotTH = dot(stangent1, vHalf);
		float sinTH = sqrt(1.0 - dotTH * dotTH);
		float dirAtten = smoothstep(-1.0, 0.0, dotTH);
		spec1 = vec3(dirAtten * pow(sinTH, primPow));
	}
	vec3 spec2;
	{
		float dotTH = dot(stangent2, vHalf);
		float sinTH = sqrt(1.0 - dotTH * dotTH);
		float dirAtten = smoothstep(-1.0, 0.0, dotTH);
		spec2 = vec3(dirAtten * pow(sinTH, secdPow));
	}

	vec3 light_Specular = (spec1 * primColor + spec2 * secdColor * specColor.b) * lightColor;
	vec3 light_Diffuse = lightColor * diffuseColor;

  vec3 ambient = ambientColor * lightColor;

#END_CODE
#END_DEFINE


//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
      { LIGHTING_AMBIENT,          LOW,  VEC3,   "ambient"},
      { DIFFUSE_SCALE,          MEDIUM,   FLOAT,        "diffuseScale" },
      { SPECULAR_SCALE,          MEDIUM,   FLOAT,        "specScale" },
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		vec3 color =  light_Specular * specScale + light_Diffuse * diffuseScale + ambient;

		gl_FragColor = vec4(color,1.0);

#END_CODE
#END_DEFINE



//========================================================================================加阴影
#SHADER_DEFINE HairLightingShadow

  FUNCTION_INPUT =
  {
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,            LOW,  VEC3,           "ambientColor"},
		{ PRIMARY_SPEC_COLOR,          MEDIUM,   VEC3,        "primColor" },
		{ SECONDARY_SPEC_COLOR,          MEDIUM,   VEC3,        "secdColor" },
		{ PRIMARY_SPEC_POWER,          MEDIUM,   FLOAT,        "primPow" },
		{ SECONDARY_SPEC_POWER,          MEDIUM,   FLOAT,       "secdPow" },
		{ PRIMARY_SPEC_SHIFT,          MEDIUM,   FLOAT,        "primShift" },
		{ SECONDARY_SPEC_SHIFT,          MEDIUM,   FLOAT,        "secdShift" },
		{ LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
		{ LIGHTING_SPECULAR,         MEDIUM,   VEC3,         "specColor"},
		{ TANGENT_NORMAL,						 MEDIUM,   VEC3,				 "tangentNormal"},
    { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
  }
  FUNCTION_OUTPUT =
  {
		{ LIGHTING_DIFFUSE,			LOW,	VEC3,	    		"light_Diffuse" },
    { LIGHTING_SPECULAR,			LOW,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

	vec3 tangent = tangentDir;

	float shift = specColor.g;
	// 计算切线方向的偏移度
	vec3 stangent1;
	{
		stangent1 = normalize(tangent + (primShift+shift) * tangentNormal);
	}
	vec3 stangent2;
	{
		stangent2 = normalize(tangent + (secdShift+shift) * tangentNormal);
	}

	// 这里的光源方向需要指向光源
  lightDirection = -lightDirection;

	vec3 vHalf = normalize(lightDirection + viewDirection);
	vec3 spec1;
	{
		float dotTH = dot(stangent1, vHalf);
		float sinTH = sqrt(1.0 - dotTH * dotTH);
		float dirAtten = smoothstep(-1.0, 0.0, dotTH);
		spec1 = vec3(dirAtten * pow(sinTH, primPow));
	}
	vec3 spec2;
	{
		float dotTH = dot(stangent2, vHalf);
		float sinTH = sqrt(1.0 - dotTH * dotTH);
		float dirAtten = smoothstep(-1.0, 0.0, dotTH);
		spec2 = vec3(dirAtten * pow(sinTH, secdPow));
	}

  vec3 newlightColor = mix(lightColor,in_TransparentColor.xyz,in_TransparentColor.a);
  
	vec3 light_Specular = (spec1 * primColor + spec2 * secdColor * specColor.b) * newlightColor;
	vec3 light_Diffuse = newlightColor * diffuseColor;

  vec3 ambient = ambientColor * newlightColor;

#END_CODE
#END_DEFINE

