#SHADER_DEFINE MirrorVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE MirrorFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { UNIFORM_SCALE,	HIGH,	FLOAT,		"scale"},
	}
  
#SHADER_CODE
  
   vec2 newCoord = (textureCoordinate-vec2(0.5))/(1.0-scale)+vec2(0.5);
   newCoord.x =abs(newCoord.x - 0.5)*2.0 > 1.0 ? (1.0 - fract(newCoord.x)) : newCoord.x;
   newCoord.y =abs(newCoord.y - 0.5)*2.0 > 1.0 ? (1.0 - fract(newCoord.y)) : newCoord.y;
   vec3 rgb = texture2D(uniCurrentTexture,newCoord).rgb;
   gl_FragColor = vec4(rgb,1.0);

#END_CODE
#END_DEFINE
   