

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
MESH_PARTICLE_COLOR = { "particle Color", VEC4, "1.0,1.0,1.0,1.0"},
[Keywords(NON_INSTANCING, GPU_INSTANCING)]
RENDER_METHODD = { "gpu_instancing",  FLOAT, "1.0" },
#END

#DEFTAG
ShaderName = "particle_mesh"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile NON_INSTANCING GPU_INSTANCING
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
#ifdef GPU_INSTANCING
	float4 row1 : TEXCOORD4;
	float4 row2 : TEXCOORD5;
	float4 row3 : TEXCOORD6;
	float4 row4 : TEXCOORD7;
#endif
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;
float4    MESH_PARTICLE_COLOR;

v2f vert(appdata v)
{
  	v2f o;
	
#ifdef GPU_INSTANCING
	float4x4 instanceMatrix = { v.row1.x,v.row1.y,v.row1.z,v.row1.w,
							   	v.row2.x,v.row2.y,v.row2.z,v.row2.w,
							   	v.row3.x,v.row3.y,v.row3.z,v.row3.w,
							   	v.row4.x,v.row4.y,v.row4.z,v.row4.w};
	float4 pos = mul(mul(v.vertex,instanceMatrix), CAMERA_VIEWPROJ);
#else
	float4 pos = ObjectToClipPos(v.vertex);
#endif
	
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	outColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv) * MESH_PARTICLE_COLOR;
}
ENDCG
#END
