
#DEFPARAMS
_AvatarTex = {"Avator Color", TEXTURE2D, "avatartex"},
_MaskTex = {"Mask Color", TEXTURE2D, "maskcolor"},
[Enum(ON,1,OFF,0)]
_BlendState = {"belnd state", FLOAT, "0.0"},
[Enum(BlendFunc)]
_BlendSrc = {"blendsrc", FLOAT, "1.0"},
[Enum(BlendFunc)]
_BlendDst = {"blenddst", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "gift_avatar_head"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = {"%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _AvatarTex;
Texture2D _MaskTex;
SamplerState _AvatarSampler;
SamplerState _MaskSampler;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv;
	return o;
}

float4 frag(v2f i) : SV_Target
{
  float4 mainColor = _AvatarTex.Sample(_AvatarSampler, i.uv);
  float4 maskColor = _MaskTex.Sample(_MaskSampler, i.uv);
  
  float4 finalColor = float4(mainColor.rgb * maskColor.a,maskColor.a);
  return finalColor;
}
ENDCG
#END
