
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_COLOR = {"TEXTURE_COLOR", TEXTURE2D, "white" },
BGSIZE = { "BGSIZE", VEC2, "0.0,0.0"},
CENTER = { "CENTER", VEC2, "0.0,0.0"},
GRAD = { "GRAD", VEC2, "0.0,1.0"},
IMAGE_INFO = { "IMAGE_INFO", VEC2, "1.0,1.0"},
INFRAME = { "INFRAME", VEC2, "0.0,0.0"},
BLEND_MODE = {"BLEND_MODE", FLOAT, "0.0"},
FBlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},
TEXTURESIZE = { "TEXTURESIZE", VEC2, "0.0,0.0"},
#END

#DEFTAG
ShaderName = "rotate_sticker"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

float2 BGSIZE;
float2 CENTER;
float2 GRAD;
float2 TEXTURESIZE;
float2 IMAGE_INFO;
float2 INFRAME;

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float2 out_Coordinate2 : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.in_Position;
	half2 in_Coordinate = v.in_Coordinate;

	// float2 texture_size = BGSIZE * TEXTURESIZE;
	// in_Position.x = v.in_Position.x*GRAD.y + v.in_Position.y*GRAD.x;
	// in_Position.y = -v.in_Position.x*GRAD.x + v.in_Position.y*GRAD.y;
    // in_Position.x = (in_Position.x * texture_size.x + CENTER.x) / BGSIZE.x;
	// in_Position.y = (in_Position.y * texture_size.y + CENTER.y) / BGSIZE.y;
 
	// in_Position.x = (in_Position.x * texture_size.x + CENTER.x) / BGSIZE.x;
	// in_Position.y = (in_Position.y * texture_size.y + CENTER.y) / BGSIZE.y;
	// float4 in_Position_rotate = in_Position;
	// in_Position_rotate.x = (in_Position.x - CENTER.x/ BGSIZE.x) * GRADy + (in_Position.y - CENTER.y/ BGSIZE.y)*GRAD.x + CENTER.x/BGSIZE.x;
	// in_Position_rotate.y = -(in_Position.x - CENTER.x/ BGSIZE.x) * GRAD.x + (in_Position.y - CENTER.y/ BGSIZE.y)*GRAD.y + CENTER.y/BGSIZE.y;
	float2 texture_size =  TEXTURESIZE;
	in_Position.x = in_Position.x * texture_size.x + CENTER.x;
	in_Position.y = -in_Position.y * texture_size.y + CENTER.y;
	float4 in_Position_rotate = in_Position;
	in_Position_rotate.x = ((in_Position.x - CENTER.x) * GRAD.y + (in_Position.y - CENTER.y)*GRAD.x + CENTER.x)/BGSIZE.x;
	in_Position_rotate.y = (-(in_Position.x - CENTER.x) * GRAD.x + (in_Position.y - CENTER.y)*GRAD.y + CENTER.y)/BGSIZE.y;
	o.out_Coordinate2 = in_Position_rotate.xy;

	in_Position_rotate.x = in_Position_rotate.x * 2 - 1;
	in_Position_rotate.y = -in_Position_rotate.y * 2 + 1;
	
	//o.out_Coordinate = in_Coordinate;

	o.out_Coordinate = (INFRAME + in_Coordinate) * IMAGE_INFO;
	
	o.vertex = UniformNDC(in_Position_rotate);
	return o;
}

float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
   	float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

float3 BlendExclusion(float3 base, float3 blend)
{
	return (base + blend - 2.0 * (base) * (blend));
}

float BlendOverlayf(float base, float blend)
{
    return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float3 BlendHardLight(float3 base, float3 blend)
{
	return BlendOverlay(blend, base);
}

float BlendSoftLightf(float base, float blend)
{
    return ((1.0 - 2.0 * (blend))*(base)*(base) + 2.0 * (base) * (blend));
}
float BlendColorDodgef(float base, float blend)
{
    return ((blend == 1.0) ? blend : min((base) / (1.0 - (blend)), 1.0));
}

float BlendColorBurnf(float base, float blend)
{
    return ((blend == 0.0) ? blend : max((1.0 - ((1.0 - (base)) / (blend))), 0.0));
}

float BlendVividLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendColorBurnf(base, 2.0 * blend);
    }
    else
	{
        return BlendColorDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendVividLight(float3 base, float3 blend)
{
	return float3(BlendVividLightf(base.r, blend.r), BlendVividLightf(base.g, blend.g), BlendVividLightf(base.b, blend.b));
}

float3 BlendColorBurn(float3 base, float3 blend)
{
	return float3(BlendColorBurnf(base.r, blend.r), BlendColorBurnf(base.g, blend.g), BlendColorBurnf(base.b, blend.b));
}

float3 BlendColorDodge(float3 base, float3 blend)
{
	return float3(BlendColorDodgef(base.r, blend.r), BlendColorDodgef(base.g, blend.g), BlendColorDodgef(base.b, blend.b));
}

float3 BlendSoftLight(float3 base, float3 blend)
{
	return float3(BlendSoftLightf(base.r, blend.r),BlendSoftLightf(base.g, blend.g),BlendSoftLightf(base.b, blend.b));
}

float BlendHardMixf(float base, float blend)
{
    if(BlendVividLightf(base, blend) < 0.5)
	{
        return 0.0;
    }
    else
	{
        return 1.0;
    }
}

float3 BlendHardMix(float3 base, float3 blend)
{
	return float3(BlendHardMixf(base.r, blend.r), BlendHardMixf(base.g, blend.g), BlendHardMixf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
    return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
    return min(blend, base);
}

float BlendPinLightf(float base, float blend) 
{
    if(blend < 0.5)
	{
        return BlendDarkenf(base, 2.0 * blend);
    }
    else
	{
        return BlendLightenf(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}

float BlendLinearBurnf(float base, float blend)
{
    return max(base + blend - 1.0, 0.0);
}

float BlendLinearDodgef(float base, float blend)
{
    return min(base + blend, 1.0);
}

float BlendLinearLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendLinearBurnf(base, 2.0 * blend);
    }
    else 
	{
        return BlendLinearDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendLinearLight(float3 base, float3 blend)
{
	return float3(BlendLinearLightf(base.r, blend.r), BlendLinearLightf(base.g, blend.g), BlendLinearLightf(base.b, blend.b));
}

float3 BlendDiff(float3 base, float3 blend)
{
	return abs(base - blend);
}

float3 BlendLinearBurn(float3 base, float3 blend)
{
	return float3(BlendLinearBurnf(base.r, blend.r), BlendLinearBurnf(base.g, blend.g), BlendLinearBurnf(base.b, blend.b));
}

float3 BlendSub(float3 base, float3 blend)
{
	return max(base - blend, float3(0.0, 0.0, 0.0));
}

float blendOverlay(float base, float blend) {
	return base<0.5?(2.0*base*blend):(1.0-2.0*(1.0-base)*(1.0-blend));
}

// float blendPinLight(float base, float blend) {
// 	return blend<0.5? max(base,2*blend-1):min(base,2*blend);
// }



Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_COLOR;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_COLOR_Sampler;
float BLEND_MODE;
float BlendOpacity;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#define in_blend_mode BLEND_MODE
	#define in_blend_opacity BlendOpacity

	float4 TextureColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.out_Coordinate.xy);
	float4 TextureImageColor = TEXTURE_COLOR.Sample(TEXTURE_COLOR_Sampler, i.out_Coordinate2.xy);
	// half4 outColr = half4(TextureColor.r ,TextureColor.g,TextureColor.b,1.0);
	//half4 outColr = float4(TextureImageColor.r ,TextureImageColor.g,TextureImageColor.b,1.0);
	float4 resultColor;
	float3 blendColor = TextureColor.rgb;
	float4 srcColor = TextureImageColor;
	float4 base = TextureImageColor;
	int blend_mode = int(in_blend_mode + 0.5);
	float FBlendOpacity = BlendOpacity * TextureColor.a;

	if( blend_mode == 1 ){
		float3 blendRGB = srcColor.rgb * (1.0 - TextureColor.a) + blendColor.rgb * TextureColor.a;
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
 	 }else if( blend_mode == 2 ){
		float3 blendRGB = clamp(srcColor.rgb + blendColor.rgb, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 3 ){
		float3 blendRGB = float3(max(srcColor.r,blendColor.r),max(srcColor.g,blendColor.g),max(srcColor.b,blendColor.b));
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 4 ){
		float3 blendRGB = srcColor.rgb * blendColor.rgb;
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 5 ){
		float3 blendRGB = float3(blendOverlay(srcColor.r,blendColor.r),blendOverlay(srcColor.g,blendColor.g),blendOverlay(srcColor.b,blendColor.b));
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 6 ){
		float3 blendRGB = 1.0-((1.0-srcColor.rgb)*(1.0-blendColor.rgb));
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 7) {
		float3 blendRGB = clamp(srcColor.rgb + 2*blendColor.rgb - 1, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}else if( blend_mode == 8) {
		float3 blendRGB = BlendPinLight(srcColor.rgb, blendColor.rgb);
		//blendRGB = blendRGB * FBlendOpacity + srcColor.rgb * (1.0 - FBlendOpacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, FBlendOpacity);
	}
	mainColor = float4(resultColor.r,resultColor.g, resultColor.b, FBlendOpacity );
}

ENDCG
#END
