require "utility"
local renderqueue = require "apolloutility.renderqueue"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local maincamerasequence = require "stylish_filter.maincamera_sequence";

local stylishFilters = {};

function stylishFilters:Initialize(cameraLayer)
    local resolution = apolloengine.Framework:GetResolution();
    self.cameraLayer = cameraLayer
    self.mainCameraSequence = nil;
    self.videoWidth = resolution:x()
    self.videoHeight = resolution:y()
    self.loop = 0
    self.frameIndex = 0
    self.loaded = false
end

function stylishFilters:LoadConfig(configfile)
    local res = true;
    local config = venusjson.LaodJsonFile(configfile);
    local version = config.version or 1;
    local photoMoodConfig = config.StylishFilters;
    local mask_keypointpath_map = {};
    local videoWidth = self.videoWidth
    local videoHeight = self.videoHeight
    if photoMoodConfig then
        local pathDir = string.match(configfile, "(.+)/[^/]*%.%w+$");
        venuscore.IFileSystem:SetResourcePath(pathDir .. "/");

        self.loop = tonumber(photoMoodConfig.Loop)

        local mainCameraEffects = photoMoodConfig.MainCameraEffects;
        if mainCameraEffects then
            local camera = renderqueue:GetCamera(self.cameraLayer)
            self.mainCameraSequence = maincamerasequence(mainCameraEffects, camera);
        end
        self.loaded = true
    end
    if not res then
        self:ReleaseResource();  --加载失败，自己调用卸载，避免外部不调用卸载
        self.loaded = false
    end
    return res;
end

function stylishFilters:SetShow(show)
    if self.mainCameraSequence ~= nil then
        self.mainCameraSequence:SetShow(show)
    end
end

function stylishFilters:Update(timespan)

    if not self.loaded then
        return
    end

    if self.mainCameraSequence ~= nil then
        self.mainCameraSequence:Update(self.frameIndex);
    end

    self.frameIndex = self.frameIndex + 1

    if self.frameIndex == self.loop then
        self.frameIndex = 0
    end

end

function stylishFilters:ReleaseResource()
    if self.mainCameraSequence ~= nil then
        self.mainCameraSequence:Release()
    end
    self.mainCameraSequence = nil;
    self.loaded = false
    collectgarbage();
end

function stylishFilters:OnRecordStart()
    self.frameIndex = 0
end

return stylishFilters;