--require "venusdebug"
local detectdefined = require "facecute.transitions.transitiondefine"
local Object = require "classic"

local transition = Object:extend();

local function dotSplit(text)
    local res = {}
    for k in string.gmatch(text, "[^%.]+") do
        table.insert(res, k)
    end
    return res
end

function transition:new(ht, immortal)
    self.isshow = false
    self.prevActions = {}
    self.currActions = {}
    self.transitions = {}
    self.partWithPreState = {}
    self.partWithTrigger = {}
    self.actionWithTrigger = {}
    self.actionWithTriggerAppend = {}
    self.headTarget = ht--本状态机管理的人头资源
    self.immortal = immortal --本状态机管理的常驻资源
    self.activeAny = false --是否触发了初始化动作
end

function transition:ParseConfig(config)
    self.isshow = false
    self.activeAny = false
    self.prevActions = {}
    self.currActions = {}
    self.transitions = {}
    self.partWithPreState = {}
    self.partWithTrigger = {}
    self.actionWithTrigger = {}
    self.actionWithTriggerAppend = {}

    local jTransitions = config["transitions"];

    for jTransName, jTrans in pairs(jTransitions) do
        local trans = {}
        trans.name = jTransName
        trans.conditions = {}
        trans.targets = {}

        for _, jCond in ipairs(jTrans.conditions) do

            local cond = {}

            local splits = nil

            splits = dotSplit(jCond.preState)
            if #splits >= 2 then
                cond.preStateEntity = splits[1]
                cond.preStateState = splits[2]
                self.partWithPreState[cond.preStateEntity] = "invisible"
            elseif #splits == 0 then
                cond.preStateEntity = "*"
                cond.preStateState = "*"
            else
                ERROR("error in parse transition 1")
            end


            splits = dotSplit(jCond.triggers)
            if #splits >= 3 then
                cond.triggerCategory = splits[1]
                cond.triggerEntity = splits[2]
                cond.triggerEvent = splits[3]
                if cond.triggerCategory == "H" then
                    self.actionWithTrigger[cond.triggerEntity] = "disappear"
                elseif cond.triggerCategory == "A" then
                    self.partWithTrigger[cond.triggerEntity] = "hide"
                end
            elseif #splits == 0 then
                cond.triggerCategory = "*"
                cond.triggerEntity = "*"
                cond.triggerEvent = "*"
            else
                ERROR("error in parse transition 2")
            end

            table.insert(trans.conditions, cond)
        end

        for _, jTarget in ipairs(jTrans.targets) do
            local target = {
                delay = jTarget.delay,
                fadingFrame = jTarget.fadingFrame,
                lastingFrame = jTarget.lastingFrame,
                loop = jTarget.loop,
                targetPart = jTarget.targetPart,
                targetState = jTarget.targetState
            }
            table.insert(trans.targets, target)
        end

        trans.randomShow = jTrans.randomShow
        if trans.randomShow == nil then
            trans.randomShow = false
        end

        table.insert(self.transitions, trans)
    end
    self.actionWithTriggerAppend["background"] = "appear"
    self.actionWithTriggerAppend["front"] = "appear"
end


--设置是否显示
function transition:SetShow(isshow)

    if self.isshow ~= isshow then
        self.isshow = isshow

        if isshow then --当人头出现的时候
            self.actionWithTriggerAppend["face"] = "appear"
        else --当人头消失的时候
            self.actionWithTriggerAppend["face"] = "disappear"
        end
    end
end

function transition:TakeTarget(target)
    if target == nil then
        return
    end

    local obj = self.headTarget:getAsset(target.targetPart)
    if obj == nil then
        obj = self.immortal:getAsset(target.targetPart)
    end
    if obj ~= nil then
        local v = target
        local eventArgs = {
            delay = v.delay == 0 and nil or v.delay,
            lasting = v.lastingFrame == 0 and nil or v.lastingFrame,
            fading = v.fadingFrame == 0 and nil or v.fadingFrame,
            loop = v.loop
        }
        obj:Trigger(target.targetState, eventArgs)
    end
end


local function UpdateActionTable(currActions, inputActions)
    for name, _ in pairs(detectdefined.actionBaseNameIdTable) do
        currActions[name] = false
    end
    if inputActions == nil then
        return
    end
    for _, action in ipairs(inputActions) do
        if action.actionid ~= 256 and  action.actionid ~= 257 and action.actionid ~= 16777216 and action.actionid ~= 16777217 then
            local actionName = detectdefined.triggerList[action.actionid]
            if actionName == nil then
                goto CONTINUE
            end

            local splits = dotSplit(actionName)
            if #splits == 3 then
                local actionBaseName = splits[2]
                local appearing = (splits[3] == "appear")
                currActions[actionBaseName] = appearing
            end
        end
        ::CONTINUE::
    end
end


function transition:Update(action, index)

    if self.transitions == nil then
        return
    end

    --更新partWithTrigger表
    for entity, _ in pairs(self.partWithTrigger) do
        local obj = self.headTarget:getAsset(entity)
        if obj == nil then
            obj = self.immortal:getAsset(entity)
        end

        if obj ~= nil then
            local trigger = obj:TestTrigger();
            if trigger == nil then
                self.partWithTrigger[entity] = ""
            else
                self.partWithTrigger[entity] = detectdefined.TargetStateList[trigger]
            end
        end
    end

    --更新actionWithTrigger表
    UpdateActionTable(self.currActions, action)
    for entity, _ in pairs(self.actionWithTrigger) do
        if self.prevActions[entity] ~= self.currActions[entity] then
            self.actionWithTrigger[entity] = self.currActions[entity] and "appear" or "disappear"
        else
            self.actionWithTrigger[entity] = ""
        end
    end
    for entity, event in pairs(self.actionWithTriggerAppend) do
        self.actionWithTrigger[entity] = event
    end
    self.actionWithTriggerAppend = {}

    --对于每一个transition
    for _, trans in ipairs(self.transitions) do

        local conditionMet = false

        --该transition中的任意一个condition满足
        for _, cond in ipairs(trans.conditions) do

            local preStateMatched = false
            local eventTriggered = false

            if cond.preStateEntity == "*" then
                preStateMatched = true
            else
                preStateMatched = (self.partWithPreState[cond.preStateEntity] == cond.preStateState)
            end

            if cond.triggerCategory == "H" then
                if self.actionWithTrigger[cond.triggerEntity] == cond.triggerEvent then
                    eventTriggered = true
                end
            elseif cond.triggerCategory == "A" then
                local obj = self.headTarget:getAsset(cond.triggerEntity)
                if obj == nil then
                    obj = self.immortal:getAsset(cond.triggerEntity)
                end
                if obj ~= nil then
                    eventTriggered = (self.partWithTrigger[cond.triggerEntity] == cond.triggerEvent)
                end
            elseif cond.triggerCategory == "*" then
                eventTriggered = not self.activeAny
            end

            conditionMet = (preStateMatched and eventTriggered)

            if conditionMet then
                break
            end
        end

        --则执行targets
        if conditionMet then

            --LOG(string.format("SUNTYLOG: taking transition %s", trans.name))

            if not trans.randomShow then
                for _, target in ipairs(trans.targets) do
                    self:TakeTarget(target)
                end
            else
                local index = math.random(#trans.targets)
                local target = trans.targets[index]
                if target ~= nil then
                    self:TakeTarget(target)
                end
            end
        end

    end

    --更新partWithPreState表
    --放在后面更新的原因是为了这种case: preState=A.playing, triggers=A.hide
    --例子：圣诞老虎机
    for entity, _ in pairs(self.partWithPreState) do
        local obj = self.headTarget:getAsset(entity)
        if obj == nil then
            obj = self.immortal:getAsset(entity)
        end
        if obj ~= nil then
            self.partWithPreState[entity] = obj:GetState()
        end
    end

    self.prevActions = self.currActions
    self.currActions = {}

    self.activeAny = true
end

return transition;
