local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local pnpestimates = require "pnpestimates"
local videodecet = require "videodecet"


local epnp = {}
--初始化
function epnp:Initialize(camera)
  self.postureestimates = {}
  self.pnp = pnpestimates.EPnPShell();
  local resolution = apolloengine.Framework:GetResolution();
  local max = math.max(resolution:x(), resolution:y());
  self.pnp:SetIntrinsic(max, max, 0.5*resolution:x(), 0.5*resolution:y());
  
  --模型选点
  local vec3array = mathfunction.vector3array();
  vec3array:PushBack(mathfunction.vector3(-0.04175, 0.04588, 0.02506));--左眼外角
  vec3array:PushBack(mathfunction.vector3(-0.01688, 0.0449, 0.03133));--左眼内角
  vec3array:PushBack(mathfunction.vector3(0.04174, 0.04588, 0.02506));--右眼外角
  vec3array:PushBack(mathfunction.vector3(0.01688, 0.0449, 0.03133));--右眼内角
  vec3array:PushBack(mathfunction.vector3(0, 0.017, 0.0633));--鼻子
  vec3array:PushBack(mathfunction.vector3(0, -0.05148, 0.04432));--下巴
  self.pnp:SetModelPoints(vec3array);
  
  --初始化屏幕坐标点数组备用
  self.screenpos = mathfunction.vector2array();
  self.screenpos:Resize(6);
end

function epnp:GetPostures()
  return self.postureestimates;
end

local function _toPixel(point, resolution)
  return resolution:x() * (point[1] * 0.5 + 0.5),
    resolution:y() * (0.5 - point[2] * 0.5)
end

function epnp:Update(faces,maincamera)
  self.postureestimates = {}
  local resolution = apolloengine.Framework:GetResolution();
  local vec2 = mathfunction.vector2();
  for _, face in ipairs(faces) do
    local left_eye_out = face:GetKeypoint(52)--左眼外角
		local left_eye_in = face:GetKeypoint(55)--左眼内角
    local right_eye_out = face:GetKeypoint(61)--右眼外角
		local right_eye_in = face:GetKeypoint(58)--右眼内角
    local nose = face:GetKeypoint(46)--鼻子
    local chin = face:GetKeypoint(16)--下巴
    vec2:Set(_toPixel(left_eye_out, resolution));
    self.screenpos:Set(1, vec2);
    
    vec2:Set(_toPixel(left_eye_in, resolution));
    self.screenpos:Set(2, vec2);
    
    vec2:Set(_toPixel(right_eye_out, resolution));
    self.screenpos:Set(3, vec2);
    
    vec2:Set(_toPixel(right_eye_in, resolution));
    self.screenpos:Set(4, vec2);
    
    vec2:Set(_toPixel(nose, resolution));
    self.screenpos:Set(5, vec2);
    
    vec2:Set(_toPixel(chin, resolution));
    self.screenpos:Set(6, vec2);
    
    self.pnp:Estimates(self.screenpos);
    
    local pos = {
	    position = self.pnp:GetTransform();
	    rotation = self.pnp:GetRotation();
	  }
	  table.insert(self.postureestimates, pos);
  end  
end

return epnp;