local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local pnpestimates = require "pnpestimates"
local cv = require "computervisionfunction"


local Transposture = venuscore.VenusBehavior:extend("TranspostureBehavior");

function Transposture:new()
    --self.recogition=nil;
    self.headid =1;
    self.positionBindingTarget = "Face"
    self.activenessBindingTarget = "Face"
end

function Transposture:GetHeadId()
    return  self.headid;
end

function Transposture:SetHeadId(rec)
    
    self.headid = rec;
end

function Transposture:GetRecognition()
    return  self.recognition;
end

function Transposture:SetRecognition(rec)
    
    self.recognition = rec;
end

function Transposture:GetCamera()
    return  self.camera;
end

function Transposture:SetCamera(camera)
    self.camera = camera;
end

function Transposture:GetTransform()
    if self.transform == nil and not venuscore.isNil(self.target) then
        self.transform = self.target:GetComponent(apolloengine.Node.CT_TRANSFORM)
    end
    return self.transform;
end

function Transposture:GetResolution()
    local camera = self:GetCamera();
    if not venuscore.isNil(camera) and self.pnp ~= nil then
        local resolution = camera.CameraResolution;
        local max = math.max(resolution:x(), resolution:y());

        local cx = 0.5*resolution:x();
        local cy = 0.5*resolution:y();

        local projectionmat = camera:GetProject();
        local fx = projectionmat.a11;
        local fy = projectionmat.a22;

        fx = fx * cx;
        fy = fy * cy;
       
        if math.abs(fx-fy)<0.01 then
            
        else
            LOG("DIFF FOCUS DISTANCE"..fx.." "..fy);
        end

        self.pnp:SetIntrinsic(fx, fy, cx,cy);
    end
    return nil
end

function Transposture:_Play()

end

function Transposture:_OnAwake()

end

function Transposture:_OnStart()
  
end

function Transposture:Init()
    local transform = self:GetTransform();
    if transform == nil then
        return
    end
    if self.initrot==nil then
        local transform = self:GetTransform();
        self.initrot = transform:GetWorldRotation();
    end 

    if self:GetCamera() ~= nil and self.isInited==nil then
        self.isInited = true;
        self.postureestimates = {}
        self.pnp = pnpestimates.TranslationShell();
        local resolution = self:GetCamera().CameraResolution;
        local max = math.max(resolution:x(), resolution:y());

        local cx = 0.5*resolution:x();
        local cy = 0.5*resolution:y();

        local projectionmat = self:GetCamera():GetProject();
        local fx = projectionmat.a11;
        local fy = projectionmat.a22;
        fx = fx * cx;
        fy = fy * cy;

        if math.abs(fx-fy)<0.01 then
            
        else
            LOG("DIFF FOCUS DISTANCE"..fx.." "..fy);
        end

        self.pnp:SetIntrinsic(fx, fy, cx,cy);
        
        --模型选点
        local vec3array = mathfunction.vector3array();
        vec3array:PushBack(mathfunction.vector3(-0.04175, 0.04588, 0.02506));--左眼外角
        vec3array:PushBack(mathfunction.vector3(-0.01688, 0.0449, 0.03133));--左眼内角
        vec3array:PushBack(mathfunction.vector3(0.04174, 0.04588, 0.02506));--右眼外角
        vec3array:PushBack(mathfunction.vector3(0.01688, 0.0449, 0.03133));--右眼内角
        vec3array:PushBack(mathfunction.vector3(0, 0.017, 0.0633));--鼻子
        --vec3array:PushBack(mathfunction.vector3(0, -0.05148, 0.04432));--下巴
        self.pnp:SetModelPoints(vec3array);
        
        --初始化屏幕坐标点数组备用
        self.screenpos = mathfunction.vector2array();
        self.screenpos:Resize(5);
    end
end

function Transposture:GetProperties()
    return
    {
      "Face",
      "Male",
      "EyeBlink",
      "MouthOpen",
      "HeadYaw",
      "HeadPitch",
      "BrowJump",
      "MouthPout",
      "FaceSmile",
      "HandOK",
      "HandScissor",
      "HandGood",
      "HandPalm",
      "HandPistol",
      "HandLove",
      "HandHoldup",
      "HandCongrats",
      "HandFingerHeart",
      "HandTwoIndexFinger",
      "HandFingerIndex",
      "HandFist",
      "Hand666",
      "HandBless",
    };
end

function Transposture:GetScriptPropValue(prop)
    return self[prop]
end

function Transposture:SetScriptPropValue(prop, value)
    self[prop] = value
end

function Transposture:_OnUpdate(timespan)
    self:Init();
    self:GetResolution()

    local scriptProps = self:GetProperties()
    for _, prop in ipairs(scriptProps) do
        self[prop] = false
    end

    self:_UpdateRecogProperty()

    self:_UpdateClassifyProperty()

    if self.activenessBindingTarget ~= nil then
        if self[self.activenessBindingTarget] then
            --Auto Activate
            if not venuscore.isNil(self.target) and not self.target.Active then
                self.target.Active = true
                --LOG("SUNTYLOG: Transposture:_OnUpdate: Auto Activate")
            end
        else
            --Auto Deactivate
            if not venuscore.isNil(self.target) and self.target.Active then
                self.target.Active = false
                --LOG("SUNTYLOG: Transposture:_OnUpdate: Auto Deactivate")
            end
        end
    end
    if self.positionBindingTarget ~= nil then
        if self[self.positionBindingTarget] then
            --Bind Position
            if self.positionBindingTarget == "Face" then
                self:_BindingHeadPosition()
            else
                self:_BindingGesturePosition()
            end
        end
    end
end

function Transposture:_UpdateRecogProperty()
    self.recogResult = nil
    if venuscore.isNil(self:GetRecognition()) then
        return;
    end
    local results = self:GetRecognition():GetResult();
    if results == nil then
        return
    end
    local faceResults = results[cv.RecognitionComponent.cvFace]
    if faceResults ~= nil and faceResults[self.headid] ~= nil then
        local faceResult = faceResults[self.headid]
        self.Face = true;
        self.recogResult = faceResult
    end
    local attrResults = results[cv.RecognitionComponent.cvFaceAttribution]
    if attrResults ~= nil and attrResults[self.headid] ~= nil then
        local attrResult = attrResults[self.headid]
        if attrResult[1] >= 0.5 then
            self.Male = true
        else
            self.Male = false
        end
        self.attrResult = attrResult
    end
end

function Transposture:_BindingHeadPosition()

    if self:GetCamera() == nil or self.screenpos == nil or self.pnp == nil then
        return
    end
    
    local facerets = self.recogResult

    if facerets == nil then
        return
    end

    self.postureestimates = {}
    --local resolution = apolloengine.Framework:GetResolution();
    local vec2 = mathfunction.vector2();
   
    local left_eye_out = {facerets[53*2-1],facerets[53*2]}--左眼外角
    local left_eye_in =  {facerets[56*2-1],facerets[56*2]}--左眼内角
    local right_eye_out = {facerets[62*2-1],facerets[62*2]}--右眼外角
    local right_eye_in =  {facerets[59*2-1],facerets[59*2]} --右眼内角
    local nose =  {facerets[47*2-1],facerets[47*2]}           --鼻子     
    --local chin = face:GetKeypoint(16)--下巴

    vec2:Set(left_eye_out[1],left_eye_out[2]);
    self.screenpos:Set(1, vec2);
    
    vec2:Set(left_eye_in[1],left_eye_in[2]);
    self.screenpos:Set(2, vec2);
    
    vec2:Set(right_eye_out[1],right_eye_out[2]);
    self.screenpos:Set(3, vec2);
    
    vec2:Set(right_eye_in[1],right_eye_in[2]);
    self.screenpos:Set(4, vec2);
    
    vec2:Set(nose[1],nose[2]);
    self.screenpos:Set(5, vec2);
    
    local picthyawroll = {};
    picthyawroll[1] = facerets[109*2-1]
    picthyawroll[2] = facerets[110*2-1]
    picthyawroll[3] = facerets[111*2-1]
    --vec2:Set(_toPixel(chin, resolution));
    --self.screenpos:Set(6, vec2);
    --local anguler = face:GetRotation();    
    self.pnp:Estimates(
        math.rad(picthyawroll[1]),
        math.rad(picthyawroll[2]),
        math.rad(picthyawroll[3]),
        self.screenpos);
    
    local pos = {
        position = self.pnp:GetTransform();
        rotation = self.pnp:GetRotation();
    }

    table.insert(self.postureestimates, pos);

    local transform = self:GetTransform();
    if transform then
        local cameramat = self:GetCamera():GetView():Inverse();

        local camtrans = cameramat:ToTransform();
        local camrot = cameramat:ToQuaternion();        

        local modelpos = camtrans + pos.position*camrot;
        local modelrot = self.initrot*pos.rotation*camrot;
        transform:SetLocalPosition(modelpos);
        transform:SetLocalRotation(modelrot);
    end
end

function Transposture:_UpdateClassifyProperty()
    self.classifyResult = nil
    if not venuscore.isNil(self.classify) then
        local classifyResult = self.classify:GetResultById(self.headid)
        if classifyResult ~= nil then
            for i = 1, #classifyResult do
                local item = classifyResult[i]
                self[item.ActionName] = true
            end
        end
        self.classifyResult = classifyResult
    end
end

local function _toRelativeCoordinates(pixel_x, pixel_y, res)
    return pixel_x / res.mx * 2 - 1, 1 - pixel_y / res.my * 2;
end

local function _toLength(pixel_x, pixel_y, res)
    local x, y = pixel_x / res.mx, pixel_y / res.my;
    return math.sqrt(x*x+y*y);
end

function Transposture:_BindingGesturePosition()
    if self:GetCamera() == nil then
        return
    end
    local classifyResult = self.classifyResult
    if classifyResult == nil then
        return
    end
    for _, action in ipairs(classifyResult) do
        if action.ActionName == self.positionBindingTarget then
            local res = self:GetCamera():GetCameraResolution();
            local cx = action.Rect[1] + action.Rect[3] * 0.5
            local cy = action.Rect[2] + action.Rect[4] * 0.5
            cx, cy = _toRelativeCoordinates(cx, cy, res);
            local center = mathfunction.vector2(cx, cy);
            local ray = self:GetCamera():PickRay(center);
            local len = _toLength(action.Rect[3], action.Rect[4], res);
            local len_inv = 0.3 / len;
            local wpos = ray:GetOrigin() + ray:GetDirection() * len_inv;
            self:GetTransform():SetLocalPosition(wpos);
            break
        end
    end
end

function Transposture:GetPostureEstimates()
    return self.postureestimates;
end

Transposture:MemberRegister(
    "target",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.Node:RTTI(),    
        nil,
        function(thiz, value)
            thiz.target = value
            thiz.transform = thiz.target:GetComponent(apolloengine.Node.CT_TRANSFORM)
            thiz.initrot = nil
            thiz.isInited = nil
        end
    )
);

Transposture:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI(),    
    Transposture.GetCamera,
    Transposture.SetCamera
)); 

Transposture:MemberRegister("recognition",
    venuscore.ScriptTypes.ReferenceType(
        cv.RecognitionComponent:RTTI(),    
        Transposture.GetRecognition,
        Transposture.SetRecognition
));

Transposture:MemberRegister(
    "classify",
    venuscore.ScriptTypes.ReferenceType(
        cv.ClassifyComponent:RTTI()
    )
);

Transposture:MemberRegister(
    "headid",  
    venuscore.ScriptTypes.ComboType(
        {
            {
                key = "1",
                value = 1
            },
            {
                key = "2",
                value = 2
            },
            {
                key = "3",
                value = 3
            },
        },
        Transposture.GetHeadId,
        Transposture.SetHeadId
    )
);

Transposture:MemberRegister(
    "positionBindingTarget",
    venuscore.ScriptTypes.ComboType(
        function(thiz)
            local result =
            {
                {
                    key = "None",
                    value = nil
                }
            }
            local properties = thiz:GetProperties()
            for _, prop in ipairs(properties) do
                table.insert(
                    result,
                    {
                        key = prop,
                        value = prop
                    }
                )
            end
            return result
        end
    )
)

Transposture:MemberRegister(
    "activenessBindingTarget",
    venuscore.ScriptTypes.ComboType(
        function(thiz)
            local result =
            {
                {
                    key = "None",
                    value = nil
                }
            }
            local properties = thiz:GetProperties()
            for _, prop in ipairs(properties) do
                table.insert(
                    result,
                    {
                        key = prop,
                        value = prop
                    }
                )
            end
            return result
        end
    )
)
return Transposture;