

local apolloengine  = require "apolloengine"
local mathfunction  = require "mathfunction"
local venuscore     = require "venuscore"
local defined       = require "apolloutility.defiend"
local BundleSystem = require "venuscore.bundle.bundlesystem"


local CloneBehavior = venuscore.VenusBehavior:extend("CloneBehavior")

function CloneBehavior:new()
  self.trackPersonIDList = {1,2,3}  --默认跟踪三个人脸(引擎规定最多同时支持三个人脸)
  
  self.applyMale = true;  --素材是否应用到男性身上
  self.applyFemale = true; --素材是否应用到女性身上
  
end

--放到OnStart中克隆(保证在编辑器中只有预览场景会克隆)
function CloneBehavior:_OnStart()
  self:_DoClone();
end

function CloneBehavior:_OnDestroy()
end

function CloneBehavior:_OnUpdate()

end

--根据设置克隆素材
--克隆的时候要手动删除此脚本，否则会死循环
function CloneBehavior:_DoClone()
  self:_ReleaseCloned();
  self:_Encoder();
end

--删除克隆出的东西
function CloneBehavior:_ReleaseCloned()
end

--序列化
function CloneBehavior:_Encoder()
  BundleSystem:SerializeToMemoryTable(self.Node);
end

--反序列化
function CloneBehavior:_Decoder()
end


--克隆出的素材需要刷新Layer,否则效果可能不对
function CloneBehavior:_RefreshClonedLayers()
end

CloneBehavior:MemberRegister(
  "trackPersonIDList",
  venuscore.ScriptTypes.ArrayType(
    function(this)
      return this.trackPersonIDList;
    end,
    function (this)
      return { unpack(this.trackPersonIDList) }
    end,
    function (thiz, value)
      thiz.trackPersonIDList = { unpack(value) }
    end
  )
);


CloneBehavior:MemberRegister("applyMale");
CloneBehavior:MemberRegister("applyFemale");
  


return CloneBehavior;