local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"

local CustomGiftConfigBehavior = venuscore.VenusBehavior:extend("CustomGiftConfigBehavior"); 
local maxConfigGroup = 50; 
local configSavePath = "proj:"
function CustomGiftConfigBehavior:new()
  self.version = 1;
  self.nodeList = {};  --所选择的Node引用列表
  self.attributeGroupList = {}; --可配置属性列表
  self.renderMatNameList = {};  --可更改材质列表
  self.textureSlotList = {}; --可更改纹理slot列表
  --self.testurePathList = {};  --所有用来替换的纹理路径列表
  
  self.width = 0.0;
  self.height = 0.0;
  self.playWidth = 0.0;
  self.playHeight = 0.0;
  self.fps = 30;
end

function CustomGiftConfigBehavior:_OnAwake()
end

function CustomGiftConfigBehavior:_OnUpdate(def)
end

function CustomGiftConfigBehavior:_OnPackage()
  local configTable = {};
  configTable["Version"] = self.version;
  configTable["Fps"] = self.fps;
  local configSize = {PreviewSize = {Width = self.width,Height = self.height},
                      PlaySize = {Width = self.playWidth,Height = self.playHeight}};
  configTable["Size"] = configSize;
  local Attributes = {};
  --local extraPathList = {};
  for i = 1, maxConfigGroup do
    local groupName = self.attributeGroupList[i];
    if groupName then
      local group = {};
      group["AttributeName"] = groupName;
      group["DataType"] = "Path";
      group["Index"] = i;
      
      --[[
      local alternateTexIndexBeg = (i - 1) * 20;
      local alternateTexIndexEnd = i * 20;
      local texPathList = {};
      for m = alternateTexIndexBeg + 1, alternateTexIndexEnd do
        local texPath = self.testurePathList[m];
        if texPath then
          table.insert(texPathList,texPath);
          table.insert(extraPathList,texPath);
        end
      end
      group["AlternateTexList"] = texPathList;
      --]]

      local nodeIndexBeg = (i - 1) * 100;
      local nodeIndexEnd = i * 100;
      local nodeList = {};
      for j = nodeIndexBeg + 1,nodeIndexEnd do
        local refNode = self.nodeList[j];
        if refNode then
          local nodeStruct = {};
          local nodeName = refNode:GetName();
          nodeStruct["Name"] = nodeName;
          nodeStruct["Index"] = j;
          local slotList = {};
          local slotIndexBeg = (j - 1) * 20;
          local slotIndexEnd = j * 20;
          for k = slotIndexBeg + 1, slotIndexEnd do
            local slot = self.textureSlotList[k];
            if slot then
              local isValid = slot[2];
              if isValid then
                local slotStruct = {};
                slotStruct["Name"] = slot[1];
                slotStruct["Index"] = k;
                table.insert(slotList,slotStruct);
              end
            end
          end
          nodeStruct["SlotList"] = slotList;
          table.insert(nodeList,nodeStruct);
        end
      end
      group["NodeList"] = nodeList;
      table.insert(Attributes,group);
      --configTable[groupName]["NodeList"] = nodeList;
    end
  end
  configTable["Attributes"] = Attributes;
  
  local jsonPath = configSavePath .. "custom_gift_config.json";
  local absJsonPath = venuscore.IFileSystem:PathAssembly(jsonPath);
  venusjson.SaveJsonObject(configTable,absJsonPath);
  
  --[[
  local res = {};
  table.insert(res,jsonPath);
  for i = 1, #extraPathList do
    table.insert(res,extraPathList[i]);
  end
  --]]
  return {jsonPath};
  
end



function CustomGiftConfigBehavior:SetNodeList(nodeList)
  self.nodeList = nodeList;
end

function CustomGiftConfigBehavior:GetNodeList()
  return self.nodeList;
end

function CustomGiftConfigBehavior:SetAttributeList(attrList)
  self.attributeGroupList = attrList;
end

function CustomGiftConfigBehavior:GetAttributeList()
  return self.attributeGroupList;
end

function CustomGiftConfigBehavior:GetTextureSlotList()
  return self.textureSlotList;
end

function CustomGiftConfigBehavior:SetTextureSlotList(texSlotList)
  self.textureSlotList = texSlotList;
end

function CustomGiftConfigBehavior:GetRenderMatList()
  return self.renderMatNameList;
end

function CustomGiftConfigBehavior:SetRenderMatList(renderMatList)
  self.renderMatNameList = renderMatList;
end

--[[
function CustomGiftConfigBehavior:GetTexturePathList()
  return self.testurePathList;
end

function CustomGiftConfigBehavior:SetTexturePathList(texturePathList)
  self.testurePathList = texturePathList;
end
--]]




CustomGiftConfigBehavior:MemberRegister("fps");
CustomGiftConfigBehavior:MemberRegister("width");
CustomGiftConfigBehavior:MemberRegister("height");
CustomGiftConfigBehavior:MemberRegister("playWidth");
CustomGiftConfigBehavior:MemberRegister("playHeight");
CustomGiftConfigBehavior:MemberRegister("version");


--[[
CustomGiftConfigBehavior:MemberRegister("testurePathList",
  venuscore.ScriptTypes.ArrayType(
    CustomGiftConfigBehavior.GetTexturePathList,
    CustomGiftConfigBehavior.GetTexturePathList,
    CustomGiftConfigBehavior.SetTexturePathList
  ));
--]]

CustomGiftConfigBehavior:MemberRegister("nodeList",
  venuscore.ScriptTypes.ReferenceArrayType(
    apolloengine.Node:RTTI(),
    CustomGiftConfigBehavior.GetNodeList,
    CustomGiftConfigBehavior.SetNodeList
  )); 


CustomGiftConfigBehavior:MemberRegister("attributeGroupList",
  venuscore.ScriptTypes.ArrayType(
    CustomGiftConfigBehavior.GetAttributeList,
    CustomGiftConfigBehavior.GetAttributeList,
    CustomGiftConfigBehavior.SetAttributeList
  ));

CustomGiftConfigBehavior:MemberRegister("textureSlotList",
  venuscore.ScriptTypes.ArrayType(
    CustomGiftConfigBehavior.GetTextureSlotList,
    CustomGiftConfigBehavior.GetTextureSlotList,
    CustomGiftConfigBehavior.SetTextureSlotList
  ));

CustomGiftConfigBehavior:MemberRegister("renderMatNameList",
  venuscore.ScriptTypes.ArrayType(
    CustomGiftConfigBehavior.GetRenderMatList,
    CustomGiftConfigBehavior.GetRenderMatList,
    CustomGiftConfigBehavior.SetRenderMatList
    ));


return CustomGiftConfigBehavior;