local mathfunction = require "mathfunction"

local Utils = {}
local eps = 0.00001

function Utils.solveBarycentricWeight( px, py, p_cur)
    local o1 = mathfunction.vector4(px:x(), px:y(), px:z(), p_cur[1]);
    local o2 = mathfunction.vector4(py:x(), py:y(), py:z(), p_cur[2]);
    local o3 = mathfunction.vector4(1.0, 1.0, 1.0, 1.0);
    if math.abs(o1:x()) < eps then
        o1 = o1 + o3;
	end
    o1 = o1 / o1:x();
    o2 = o2 - o1 * o2:x();
    o3 = o3 - o1;
    if math.abs(o2:y()) < eps then    
        if math.abs(o3:y()) < eps then 
            if math.abs(o2:y()) < eps then
                return mathfunction.vector3(1, 0, 0);
            else
                return mathfunction.vector3(o1:w(), 0, o2:w() / o2:z()); 
			end
        else 
            local o_temp = o2;
            o2 = o3;
            o3 = o_temp;
        end
    end
	
    o2 = o2 / o2:y();
    o3 = o3 - o2 * o3:y();
    if math.abs(o3:z()) > eps then 
        o3 = o3 / o3:z(); 
    else 
        o3 = mathfunction.vector4(o3:x(), o3:y(), o3:z(), 0);
    end
	
    o3 = o3 / o3:z();
    o2 = o2 - o3 * o2:z();
    o1 = o1 - o2 * o1:y() - o3 * o1:z();
    return mathfunction.vector3(o1:w(), o2:w(), o3:w());
end

 
function Utils.warpByTriangle(origin,target, p) 
    local px = mathfunction.vector3(origin[1]:x(), origin[2]:x(), origin[3]:x());
    local py = mathfunction.vector3(origin[1]:y(), origin[2]:y(), origin[3]:y());

    local i1 = (origin[2]:y()- origin[1]:y()) * (origin[3]:x() - origin[1]:x()) - (origin[2]:x() - origin[1]:x()) * (origin[3]:y() - origin[1]:y());
    local i2 = (origin[3]:y() - origin[2]:y()) * (origin[1]:x() - origin[2]:x()) - (origin[3]:x() - origin[2]:x()) * (origin[1]:y() - origin[2]:y());
    local i3 = (origin[1]:y() - origin[3]:y()) * (origin[2]:x() - origin[3]:x()) - (origin[1]:x() - origin[3]:x()) * (origin[2]:y() - origin[3]:y());
    local j1 = (origin[2]:y() - origin[1]:y()) * (p[1] - origin[1]:x()) - (origin[2]:x() - origin[1]:x()) * (p[2] - origin[1]:y());
    local j2 = (origin[3]:y() - origin[2]:y()) * (p[1] - origin[2]:x()) - (origin[3]:x() - origin[2]:x()) * (p[2] - origin[2]:y());
    local j3 = (origin[1]:y() - origin[3]:y()) * (p[1] - origin[3]:x()) - (origin[1]:x() - origin[3]:x()) * (p[2] - origin[3]:y());
    
    local newpoint = {p[1], p[2]}
    if i1 * j1 >= 0.0 and i2 * j2 >= 0.0 and i3 * j3 >= 0.0 then 
        local weight = Utils.solveBarycentricWeight(px, py, p);
        local newP = target[1] * weight:x() + target[2] * weight:y() + target[3] * weight:z();
        newpoint = {newP:x(), newP:y()}
    end
    return newpoint;
end

function Utils._ArrayToVec4(pt1, pt2)
  return mathfunction.vector4(pt1[1], pt1[2], pt2[1], pt2[2]);
end

function Utils._GetVector2dLength(vec)
  return math.sqrt(vec:x() * vec:x() + vec:y() * vec:y());
end

function Utils._ArrayToVec2(pt)
  return mathfunction.vector2(pt[1], pt[2]);
end

function Utils.GetDistance(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return math.sqrt(dx * dx + dy * dy);
end

function Utils.Clone(object)
  local lookup_table = {}
  local function _copy(object)
      if type(object) ~= "table" then
          return object
      elseif lookup_table[object] then
          return lookup_table[object]
      end
      local new_table = {}
      lookup_table[object] = new_table
      for key, value in pairs(object) do
          new_table[_copy(key)] = _copy(value)
      end
      return setmetatable(new_table, getmetatable(object))
  end
  return _copy(object)
end

function Utils.ScaleWarp(currentPoint, center, radius, scaleRatio, aspect_ratio)
  local r = Utils.GetDistance({currentPoint[1] - center[1], (currentPoint[2] - center[2]) * aspect_ratio}, {0, 0});
  
  if r >= radius or math.abs(r) < eps then
    return currentPoint, 0;
  end
  
  local alpha = 1.0 - scaleRatio * (r / radius - 1.0) * (r / radius - 1.0);
  local positionToUse = {currentPoint[1], currentPoint[2]};
  positionToUse[1] = center[1] + alpha * (currentPoint[1] - center[1]);
  positionToUse[2] = center[2] + alpha * (currentPoint[2] - center[2]);
  return positionToUse, 1;
end

function Utils.LinearInterpolation(data, min, max)
  local fp = min
  local sp = min
  while fp <= max do
    if fp == sp or (data[fp][1] == 0 and data[fp][2] == 0) then
      fp = fp + 1
    else
      local unit = 1 / (fp - sp)
      local tp = sp
      sp = sp + 1
      while sp < fp do        
        data[sp][1] = (data[tp][1] * (sp - tp) + data[fp][1] * (fp - sp)) * unit
        data[sp][2] = (data[tp][2] * (sp - tp) + data[fp][2] * (fp - sp)) * unit
        sp = sp + 1
      end
    end
  end
end

return Utils