local Object = require "classic"
local ae = require "apolloengine"
local vc = require "venuscore"
require "math"
--local lfs = require "lfs"
--require"lfs"



local TextureReader = Object:extend();


function TextureReader:new()  
  self.textures = {};
  self.accTimes = {};
  self.texTureCnts = {};
  --self.accTime = 0.0;
  self.loop = true;
  self.curLoopCount = 0;
end

local function CreateTexture(path)
  local tex = ae.TextureEntity();
  tex:PushMetadata(ae.TextureFileMetadata(
      ae.TextureEntity.TU_STATIC,
      ae.TextureEntity.PF_AUTO,
      1, false,
      ae.TextureEntity.TW_CLAMP_TO_EDGE,
      ae.TextureEntity.TW_CLAMP_TO_EDGE,
      ae.TextureEntity.TF_LINEAR,
      ae.TextureEntity.TF_LINEAR,
      path));
  tex:CreateResource();
  return tex;
end
function TextureReader:GetLoopCount()
   return self.curLoopCount;
end

function TextureReader:ResetLoopCount()
    self.curLoopCount = 0;
end
function TextureReader:ReStart()

  self.accTime = 0;
  self.curLoopCount = 0;
  self.accTimes={};

end

function TextureReader:IsNewStart()
  if(self.accTime==0)
  then
    return true;
  else
    return false;
  end
end
function Reset()
  --self.accTime = 0.0;
end

function setLoop(isLoop)
  self.loop = isLoop;
end


function TextureReader:SetAccTime(time)
  self.accTime = time;
end

function TextureReader:GetTotalTime()
  return self.totalTime;
end

function TextureReader:GetTexture(rootPath, pathFormat,deltaT,fps,isLoop,beginid)
  beginid = beginid or 0;
  local b,e = string.find(pathFormat,"%%%d+d");
  local digCnt = tonumber(string.sub(pathFormat,b + 2,e - 1));
  local strBeg = string.sub(pathFormat,1,b - 1);
  local strBegNeed = strBeg;
  local strEnd = string.sub(pathFormat,e + 1,string.len(pathFormat));
 
  local digCal = 0;
  local str=beginid;
  local isExist = vc.IFileSystem:isFileExist(rootPath .. "/"..strBeg..str..strEnd);
  if(isExist==true)
     then
        digCal = 1;
        digCnt=digCal;
  end
  if(digCal==0)
  then
      for i=2,9 do
        for j=1,i-1 do
            str="0"..str;
            isExist = vc.IFileSystem:isFileExist(rootPath .. "/"..strBeg..str..strEnd);
            if(isExist==true)
            then
              digCal = i;
              break;
            end
        end
        if(digCal>0)
        then
          digCnt=digCal;
          break;
        end
      end 
  end
  
  for i = 1,digCnt,1 do
    strBeg = strBeg .. "?";
  end
  local wildCard = strBeg .. strEnd;
  local cacheKey = rootPath .. "/" .. wildCard;
  
  local accTime = self.accTimes[cacheKey];
  if accTime == nil then
    accTime = 0.0;
    self.accTimes[cacheKey] = accTime;
  end
  
  
  
  local texCnt = self.texTureCnts[cacheKey];
  if texCnt == nil then
    texCnt = vc.IFileSystem:CountingFile(rootPath,wildCard);
    self.texTureCnts[cacheKey] = texCnt;
  end
  
  
  local totalTime = texCnt / fps;
  if (math.floor((accTime + deltaT) * fps) - math.floor(accTime * fps) > 1) then  --跳帧
    accTime = accTime + 1.0 / fps;
  else
    accTime = accTime + deltaT;
  end
  
  
  if accTime >= totalTime then
    accTime = 0.0;
    self.curLoopCount=self.curLoopCount+1;
    self.accTimes[cacheKey] = accTime;  --更新时间
    if not isLoop then
      return nil;
    end
  else
    self.accTimes[cacheKey] = accTime;  --更新时间
  end

  local pathFormatCal ="";
  if(digCal~=0)
  then
      pathFormatCal=strBegNeed.."%0"..digCnt.."d"..strEnd;
  end
  
  local pathFormatNeed;
  if(digCal==0)
  then
       pathFormatNeed = pathFormat;
  else
       pathFormatNeed = pathFormatCal;
  end

    
  local picOrder = math.floor(accTime * fps) + beginid;
  local picName = string.format(pathFormatNeed,picOrder);
  local fullpath = rootPath .. "/" .. picName;
  --LOG(fullpath);
  local texTable = self.textures[cacheKey];
  if texTable then
    local tex = texTable[picOrder];
    if tex then
      local texNext = texTable[picOrder + 1];
      if texNext then
        --LOG("ONLY RETURN CURRENT TEXTURE");
        return tex, picOrder;
      else
        if picOrder < texCnt - 1 then
          local nextPicName = string.format(pathFormatNeed,picOrder + 1);
          local texNextFullPath = rootPath .. "/" .. nextPicName;
          texNext = CreateTexture(texNextFullPath);
          texTable[picOrder + 1] = texNext;
        end
        --LOG("CREATE NEXT TEXTURE AND RETURN CURRENT TEXTURE");
        return tex, picOrder;
      end
    else
      tex = CreateTexture(fullpath);
      texTable[picOrder] = tex;
      --LOG("CREATE TEXTURE ONLY");
      return tex, picOrder;
    end
  else
    texTable = {};
    local tex = CreateTexture(fullpath);
    texTable[picOrder] = tex;
    self.textures[cacheKey] = texTable;
    --LOG("CREATE PATH AND TEXTURE");
    return tex, picOrder;
  end
end


return TextureReader;