//-------------------------------------------------------------------------

//计算得到环境光照对片元的影响
#SHADER_DEFINE PBRIBLAmbientLighting

	FUNCTION_INPUT =
	{
			{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
			{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
			{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
			{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"worldnormal" },
			{ WORLDSPACE_VIEWDIRECTION,					LOW,			VEC3,					"in_ViewDirection"},
			{	Base_Reflectivity,						LOW,			VEC3,					"F0"},
			{ AO_VALUE,				HIGH,			FLOAT,				"ao" },
			{ SKY_BOX, 									NONE, 		TEXTURECUBE,	"skybox"},
	}
	FUNCTION_OUTPUT =
	{
			{ LIGHTING_AMBIENT,							LOW,			VEC3,					"light_ambient" },
	}

#SHADER_CODE

		vec3 kS;// 反射部分 镜面效果 所占的比例
		//------------------------------------------	
		float cosTheta = max(dot(normalize(worldnormal), normalize(in_ViewDirection)), 0.0);
		kS = F0 + (max(vec3(1.0-roughness),F0) - F0) * pow(1.0 - cosTheta, 5.0);

		//------------------------------------------
		vec3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
		kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多

		const float MAX_REFLECTION_LOD = 9.0;
		vec3 irradiance = textureCube(skybox, worldnormal).rgb ;
		vec3 IBL_diffuse = (kD) * ( albedo.rgb ) * irradiance;//漫反射效果


		
		vec3 R = reflect(-in_ViewDirection, worldnormal);//镜面反射射线
		vec3 prefilteredColor	= textureCube(skybox, R , MAX_REFLECTION_LOD*roughness ).rgb;

		vec3 refColor = vec3(0.04);
		refColor = mix(refColor, albedo.rgb, metallic);

		float smoothness = 1.0-roughness;
		float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 

		float oneMinusReflectivity = 0.96 - metallic*0.04; 
		oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
		float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

		float t = 1.0 - cosTheta;   // ala Schlick interpoliation
		t = t*t*t*t*t;
    	refColor = mix (refColor, vec3(grazingTerm), t);
        vec3 IBL_specular = surfaceReduction * prefilteredColor * refColor;

		vec3 light_ambient = (IBL_diffuse + IBL_specular)*ao;

#END_CODE
#END_DEFINE

//-------------------------------------------------------------------------


//计算得到环境光照对片元的影响
//（不使用环境贴图，所以需要手动设定一个反射颜色值）
#SHADER_DEFINE PBRConstIBLAmbientLighting

	FUNCTION_INPUT =
	{
			{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
			{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
			{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
			{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"worldnormal" },
			{ WORLDSPACE_VIEWDIRECTION,					LOW,			VEC3,					"in_ViewDirection"},
			{	Base_Reflectivity,						LOW,			VEC3,					"F0"},
			{ AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
			{ AO_VALUE,				HIGH,			FLOAT,				"ao" }
	}
	FUNCTION_OUTPUT =
	{
			{ LIGHTING_AMBIENT,							LOW,			VEC3,					"light_ambient" },
	}

#SHADER_CODE


		vec3 kS;// 反射部分 镜面效果 所占的比例
		//------------------------------------------
		
		float cosTheta = max(dot(normalize(worldnormal), normalize(in_ViewDirection)), 0.0);
		kS = F0 + (max(vec3(1.0-roughness),F0) - F0) * pow(1.0 - cosTheta, 5.0);
		
		//------------------------------------------
		vec3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
		kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多
	
		vec3 irradiance = in_Ambient_Light;
		vec3 IBL_diffuse = (kD) * ( albedo.rgb ) * irradiance;//漫反射效果

		vec3 refColor = vec3(0.04);
		refColor = mix(refColor, albedo.rgb, metallic);

		float smoothness = 1.0-roughness;
		float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 

		float oneMinusReflectivity = 0.96 - metallic*0.04; 
		oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
		float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

		float t = 1.0 - cosTheta;   // ala Schlick interpoliation
		t = t*t*t*t*t;
    	refColor = mix (refColor, vec3(grazingTerm), t);
        vec3 IBL_specular = surfaceReduction * in_Ambient_Light * refColor;
		
		vec3 light_ambient = (IBL_diffuse + IBL_specular)*ao;

#END_CODE
#END_DEFINE

#SHADER_DEFINE DefaultAmbientLighting

	FUNCTION_INPUT =
	{
			{ AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
			{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
			{ AO_VALUE,				HIGH,			FLOAT,				"ao" },
	}
	FUNCTION_OUTPUT =
	{
			{ LIGHTING_AMBIENT,							LOW,			VEC3,					"light_ambient" },
	}

#SHADER_CODE

		vec3 light_ambient =  in_Ambient_Light * albedo.rgb * ao;

#END_CODE
#END_DEFINE