#DEFPARAMS
UNIFORM_INPUT_TEXTURE = {"UNIFORM_INPUT_TEXTURE", TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
#END

#DEFTAG
ShaderName  = "facereshapewithshape"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 inPosition   : POSITION;
};

struct v2f
{
    float2 outTexCoord  : TEXCOORD0;
    float4 outVertexPos : SV_POSITION;
};

v2f vert(appdata v)
{
    v2f o;
    o.outVertexPos = UniformNDC(float4(v.inPosition.x, v.inPosition.y, 0.0, 1.0));
    o.outTexCoord  = float2(v.inPosition.z, v.inPosition.w);
    return o;
}

Texture2D UNIFORM_INPUT_TEXTURE;
SamplerState UNIFORM_INPUT_SAMPLER;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    #define inputTexture UNIFORM_INPUT_TEXTURE

    float x = clamp(i.outTexCoord.x, 0.001, 0.999);
    float y = clamp(i.outTexCoord.y, 0.001, 0.999);

    mainColor = UNIFORM_INPUT_TEXTURE.Sample(UNIFORM_INPUT_SAMPLER, float2(x, y));
}

ENDCG
#END